/*                                         Copyright (c) CMI Productions, 2007
 *****************************************************************************
 *  tests.c (1.0)
 *
 *  Test functions 
 ****EXTERNAL*****************************************************************
 * buttontest : For checking out the buttons
 * scrolltest : For screen write testing, an A bounces around the screen
 * wipetest   : To test out the various wipes one at a time
 *
 * These are some test routines for basic checkout of the clock and are not
 * needed for normal operations.
 ****INTERNAL*****************************************************************
 * None
 *****************************************************************************
*/

#include <ez80.h>
#include <string.h>

#include "def.h"
#include "gpio.h"
#include "timer.h"
#include "globals.h"
#include "LedMatrix.h"
#include "transition.h"

/****************************************************************************
* Routne   : buttonttest
* Gazintas : None
* IOs      : None
* Returns  : Nothing
* Globals  : None
*
* This routine reads the buttons and displays a letter based on on what
* button was pressed
****************************************************************************/
void buttontest ( void )
{
   while (1)
   {
      if (curkey==KEY_NONE)
	  {
	     ledmatrix_clear(ACTIVE_PLANE) ;
	  }
	  else if (curkey==KEY_UP)
	  {
	     ledmatrix_putc(0,0,'+',PHASEAB,ACTIVE_PLANE) ;
      }
	  else if (curkey==KEY_DOWN)
	  {
	     ledmatrix_putc(0,0,'-',PHASEAB,ACTIVE_PLANE) ;
	  }
	  else if (curkey==KEY_MENU)
	  {
	    ledmatrix_putc(0,0,'M',PHASEAB,ACTIVE_PLANE) ;
	  }
	  else if (curkey==KEY_ENTER)
	  {
	     ledmatrix_putc(0,0,'E',PHASEAB,ACTIVE_PLANE) ;
	  }
   }
}

/****************************************************************************
* Routne   : scrolltest
* Gazintas : None
* IOs      : None
* Returns  : Nothing
* Globals  : None
*
* This routine has a letter A just wonder around the screen
****************************************************************************/
void scrolltest ( void )
{
   UDWORD cntr = 0 ;
   UBYTE x=0,y=0   ;
   UBYTE dx=1,dy=1 ;

   while (1)
   {
      cntr++ ;

  	  if (cntr==0x8000)
	  {
	     cntr=0 ;
		 ledmatrix_clear(ACTIVE_PLANE) ;
         ledmatrix_putc(x,y,'A',STEADY,ACTIVE_PLANE) ;

         x+=dx ;
		 if (x>=24) dx=-1 ;
		 if (x==0 ) dx= 1 ;

         y+=dy ;
		 if (y>=8) dy=-1 ;
		 if (y==0) dy= 1 ;
  	  }
   }
}

/****************************************************************************
* Routne   : wipetest
* Gazintas : None
* IOs      : None
* Returns  : Nothing
* Globals  : None
*
* This routine does a whole passel of wipes
****************************************************************************/
void wipetest ( void )
{
   UBYTE type=TR_LINE12 ;

   /* write out both messages, one to the active plane and one to the standby plane */
   ledmatrix_clear(ACTIVE_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"HELLO",PHASEAB,ACTIVE_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"WORLD",PHASEAB,ACTIVE_PLANE) ;

   /* wait two seconds... */
   del50ms(40,DEL_NOW) ;

   /* fast-cut in the second message */
   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"12345",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"67890",PHASEAB,STANDBY_PLANE) ;
   transition(TR_CUT,TR_FAST,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;

   /* flash-cut in the second message */
   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"HELLO",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"WORLD",PHASEAB,STANDBY_PLANE) ;
   transition(TR_CUT,TR_FLASH,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;

   /* blink-cut in the second message */
   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"AAAAA",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"BBBBB",PHASEAB,STANDBY_PLANE) ;
   transition(TR_CUT,TR_BLINK,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;

   /* now scroll messages */
   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"-----",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"+++++",PHASEAB,STANDBY_PLANE) ;
   transition(TR_SCROLL,TR_LEFT,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;

   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"AAAAA",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"BBBBB",PHASEAB,STANDBY_PLANE) ;
   transition(TR_SCROLL,TR_RIGHT,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;

   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"-----",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"+++++",PHASEAB,STANDBY_PLANE) ;
   transition(TR_SCROLL,TR_DOWN,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;

   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"CCCCC",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"AAAAA",PHASEAB,STANDBY_PLANE) ;
   transition(TR_SCROLL,TR_UP,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;
   
   /* now do wipe1's */
   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"-----",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"+++++",PHASEAB,STANDBY_PLANE) ;
   transition(TR_WIPE1,TR_LEFT,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;

   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"EEEEE",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"AAAAA",PHASEAB,STANDBY_PLANE) ;
   transition(TR_WIPE1,TR_RIGHT,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;

   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"+++++",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"-----",PHASEAB,STANDBY_PLANE) ;
   transition(TR_WIPE1,TR_DOWN,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;

   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"GGGGG",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"AAAAA",PHASEAB,STANDBY_PLANE) ;
   transition(TR_WIPE1,TR_UP,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;

   /* now do wipe2's */

   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"--+--",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"++-++",PHASEAB,STANDBY_PLANE) ;
   transition(TR_WIPE2,TR_LEFT,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;

   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"IIIII",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"AAAAA",PHASEAB,STANDBY_PLANE) ;
   transition(TR_WIPE2,TR_RIGHT,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;

   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)">>*<<",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"<<$>>",PHASEAB,STANDBY_PLANE) ;
   transition(TR_WIPE2,TR_DOWN,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;

   ledmatrix_clear(STANDBY_PLANE) ;
   ledmatrix_puts(0,0,(UBYTE*)"KKKKK",PHASEAB,STANDBY_PLANE) ;
   ledmatrix_puts(0,8,(UBYTE*)"AAAAA",PHASEAB,STANDBY_PLANE) ;
   transition(TR_WIPE2,TR_UP,type,FALSE) ;   
   del50ms(20,DEL_NOW) ;

   /* wait for two seconds */
   del50ms(20,DEL_NOW) ;
}

