/*                                         Copyright (c) CMI Productions, 2007
 *****************************************************************************
 *  main.c
 *
 *  Main routine for the clock 
 ****EXTERNAL*****************************************************************
 * main : What main does!
 ****INTERNAL*****************************************************************
 * 
 *****************************************************************************
*/

#include <ez80.h>
#include <stdio.h>

#include "def.h"
#include "globals.h"
#include "LedMatrix.h"
#include "transition.h"
#include "time.h"
#include "timer.h"
#include "syscalls.h"
#include "gpio.h"
#include "wwvb.h"
#include "menus.h"
#include "tests.h"

/* local global constants and variables (this file only) */

/****************************************************************************
* Routne   : main
* Gazintas : None
* IOs      : None
* Returns  : Nothing
* Globals  : None (directly)
*
* This routine basically calls all the initialization routines, then fires
* off the LED matrix display code.  It will do more--later.
****************************************************************************/
void main( void )
{
   /* initialize stuff */
   _init_default_vectors()    ; /* set up IRQ vectors to defaults         */
   gpio_init()                ; /* set up GPIO ports                      */
   wwvb_init()                ; /* initialize the radio                   */
   time_init()                ; /* set up valid default time 12:00 1/1/07 */
   ledmatrix_init()           ; /* Set up display buffer and refresh      */

   ledmatrix_led_test()       ; /* do our power-up LED test               */
// wipetest()                 ; /* do the wipe test                       */
// buttontest() ;             ; /* a button test                          */
// scrolltest() ;             ; /* scroll the letter A across the "screen"*/

   /* initializing done, get and show time */
   time_get() ;
   showtime(SHOWTIME_SSSEQ) ;

   /* the main loop is just waiting for a menu key and reacting when it   */
   /* is pressed.  All time display, WWVB updates, etc are all handled by */
   /* the timer interrupt routines.                                       */
   while( 1 )
   {
      if (curkey==KEY_MENU)
	  {
         menus() ;
		 showtime (SHOWTIME_SSSEQ) ;

	  } ;
   }
}
