; =============================================================================
; These are the assembly language helper routines for reading/writing the 
; information page of flash.  The are based toally on the Zilog Technical
; Note TN003101-0504.  Only changes are cosmetic (so far).
; =============================================================================
;	read_data_from_infopage 
;   write_byte_to_infopage
;   unlock_flash
;   erase_info_page
;   lock_flash
; =============================================================================
; Things to remember:
; 1) Only IX and SP need to be preserved by assembly code
; 2) Paramebter #1 is at (ix+3), #2 at (ix+6)
; 3) Parameters are pushed last-parameter-first
; =============================================================================
		.assume ADL=1
INCLUDE		"ez80f91.inc"

; Stuff in this file that needs to be found globally
xdef	_read_data_from_infopage
xdef	_write_byte_to_infopage
xdef	_unlock_flash
xdef	_erase_info_page
xdef	_lock_flash

; Global stuff that needs to be found locally
;XREF	

; Local Equates
FLASH_CTRL_DATA equ %48 ;adds 4 wait states and enables internal flash
FLASH_KEY_DATA1 equ %B6 ;First unlock command for Flash
FLASH_KEY_DATA2 equ %49 ;Second unlock command for Flash
FLASH_FDIV_DATA equ %FF ;To program flash memory, for processor working at 50MHz clock

		SEGMENT code
; =============================================================================
; Routine: read_data_from_infopage
; Gazinta #1 (IX+3) Row (0-1)
; Gazinta #2 (IX+6) Column (0-255)
; Gazoutas: A = byte read
; =============================================================================
; This routine reads a byte from the information page.  Row and Column are just
; the physical addressing scheme, nothing special about them
; =============================================================================
_read_data_from_infopage:
		ld		iy, %00 			; Store the stack pointer(SP)
		add		iy, sp 				; in IY register
		ld		a, %80 				; Select the Information Page
		out0 	(FLASH_PAGE), a		; make it so.
		ld 		a, (iy+3) 			; Retrieve the information on the
		out0	(FLASH_ROW), a 		; ROW addressing
		ld		a, (iy+6) 			; Retrieve the information on the
		out0	(FLASH_COL), a 		; COLUMN addressing
		in0 	a, (FLASH_DATA) 	; Read the data and store in accumulator
		ret							; All done return with data in accumulator

; ============================================================================
; Routine: _write_byte_to_infopage:
; Gazinta #1 (IX+3) byte to write
; Gazinta #2 (IX+6) row (0-1)
; Gazinta #3 (IX+9) column (0-255)
; Gazoutas: None
; =============================================================================
; This routine writes a byte to the information page.  Addressing is per
; physical addressing.  Note that there is no pre-checking the byte about to
; be written to is already blank.  It should be.
; =============================================================================
_write_byte_to_infopage:
		ld 		iy ,%0				; Store the stack pointer (SP)
		add 	iy, sp				; in IY register
		ld 		a,%80				; Select the Information Page
		out0 	(FLASH_PAGE),a		; Make it so
		ld 		a, (iy+6)			; Retrieve the information on the
		out0 	(FLASH_ROW),a 		; ROW addressing
		ld 		a, (iy+9)			; Retrieve the information on the
		out0 	(FLASH_COL),a 		; COLUMN addressing
		ld 		a, (iy+3)			; Retrieve the data to be written to the info page
		out0	(FLASH_DATA),a 		; Write the data
		ret


; =============================================================================
; Routine: _unlock_flash 
; Gazintas: None 
; Gazoutas: None
; =============================================================================
; This routine unlocks *all* flash, not just the information page for writing.
; =============================================================================
_unlock_flash:
		ld		a, FLASH_KEY_DATA1
		out0	(FLASH_KEY),a		;Write the first unlock command for flash memory
		ld 		a, FLASH_KEY_DATA2
		out0	(FLASH_KEY),a 		;Write second unlock command for flash memory
		ld 		a,%00
		out0	(FLASH_PROT),a 		;Unprotect all 32Kb blocks in the flash
		ld		a, FLASH_KEY_DATA1
		out0	(FLASH_KEY),a 		;Write the first unlock command for flash memory
		ld		a, FLASH_KEY_DATA2
		out0	(FLASH_KEY),a 		;Write second unlock command for flash memory
		ld		a, %FF
		out0	(FLASH_FDIV),a		;Write the Flash frequency divide registers
		ret


; =============================================================================
; Routine: _erase_info_page 
; Gazintas: None
; Gazoutas: None
; =============================================================================
; This routine erases the entire information page (no choice).
; =============================================================================
_erase_info_page:
		ld		a,%80				; Select the Information Page
		out0	(FLASH_PAGE),a		; Make it so
		ld		a, %02				; Erase the information Page
		out0	(FLASH_PGCTL),a		; Make it so
		ret							; All done


; =============================================================================
; Routine: lock_flash
; Gazintas: None
; Gazoutas: None
; =============================================================================
; This routine locks down all flash to prevent accidental writes or erases.
; =============================================================================
_lock_flash:
		ld		a,%ff				; Lock the flash controller by writing FF
		out0	(FLASH_PROT), a		; Make it so.
		ret							; All done

