/*                                                   Copyright (c) ZiLOG, 2003
*****************************************************************************
*  Buttons.c (1.0)
*
*  demo functions for buttons on the ZiLOG Development Board
* These routines set up port B bits 0-2 to be interrupt driven button ISRs.
* When pressed, input_flag gets set and input_data is set to ASCII '1'-'3'.
****EXTERNAL*****************************************************************
* pb0_isr : Port B bit 0 low-going ISR (button '1')
* pb1_isr : Port B bit 1 low-going ISR (button '2')
* pb2_isr : Port B bit 2 low-going ISR (button '3')
* buttons_init : Initialize Port B for ISRs for bits 0-2
****INTERNAL*****************************************************************
* NONE
*****************************************************************************
 */

#include <ez80.h>
#include "globals.h"
#include "buttons.h"
#include "syscalls.h"

char input_flag ;
char input_data ;



/* Port B interrupt vectors for the various eZ80 and eZ80Acclaim! devices */
#ifdef _EZ80F91
#define PB0_IVECT 0xA0
#define PB1_IVECT 0xA4
#define PB2_IVECT 0xA8
#endif

#ifdef _EZ80F93
#define PB0_IVECT 0x30
#define PB1_IVECT 0x32
#define PB2_IVECT 0x34
#endif

#ifdef _EZ80F92
#define PB0_IVECT 0x30
#define PB1_IVECT 0x32
#define PB2_IVECT 0x34
#endif

#ifdef _EZ80L92
#define PB0_IVECT 0x30
#define PB1_IVECT 0x32
#define PB2_IVECT 0x34
#endif

#ifdef _EZ80190
#define PB0_IVECT 0x26
#define PB1_IVECT 0x28
#define PB2_IVECT 0x2a
#endif

/****************************************************************************
*  GPIO Port B 0 interrupt service routine
*
*  display a 1 on the LED matrix
****************************************************************************/
void interrupt pb0_isr( void )
{
   input_data='1' ; /* flag an ASCII '1'       */
   input_flag= 1  ; /* flag the data available */
   PB_DR = 0x01 ;   /* clear the interrupt     */
}

/****************************************************************************
*  GPIO Port B 1 interrupt service routine
*
*  display a 2 on the LED matrix
****************************************************************************/
void interrupt pb1_isr( void )
{
   input_data='2' ; /* flag an ASCII '2'       */
   input_flag= 1  ; /* flag the data available */
   PB_DR = 0x02 ;   /* clear the interrupt     */
}

/****************************************************************************
*  GPIO Port B 3 interrupt service routine
*
*  display a 3 on the LED matrix
****************************************************************************/
void interrupt pb2_isr( void )
{
   input_data='3' ; /* flag an ASCII '3'       */
   input_flag= 1  ; /* flag the data available */
   PB_DR = 0x04 ;   /* clear the interrupt     */
}


/****************************************************************************
*  Initialize the button interrupts
*
****************************************************************************/
void buttons_init( void )
{
   /* set port B 0-2 interrupt vectors */
   set_vector( PB0_IVECT, pb0_isr );
   set_vector( PB1_IVECT, pb1_isr );
   set_vector( PB2_IVECT, pb2_isr );

   //Set the Port B bits 0, 1, and 2 to falling edge triggered interrupt mode
   PB_ALT2 |= 0x07;
   PB_ALT1 |= 0x07;
   PB_DDR  |= 0x07;
   PB_DR    = 0x00;

}
