/****************************************************************************
* wwvb.h
*
****************************************************************************/

/* These are ths states of WWVB State machine */
#define WWVB_IDLE 0
#define WWVB_PREP 1
#define WWVB_SYNC1 2
#define WWVB_SYNC2 3
#define WWVB_GDATA 4
#define WWVB_PROC1 5
#define WWVB_PROC2 6
#define WWVB_STIME 7

/* These are the defines for "live" DST changes */
#define NOTHING 0
#define TO_ST   1
#define TO_DST  2

/* Defines for what state to return */
#define WWVB_RSTATE 0
#define WWVB_RBIT 1
#define WWVB_SYM 2
#define WWVB_CNT 3

/* There is only one externally visible function                                            */
extern void  wwvb_init  ( void )                        ; /* Intitialize radio              */
extern void  wwvb_go    ( void )                        ; /* Start getting the time         */
extern UBYTE wwvb_stat ( UBYTE )                        ; /* Returen state machine states   */
extern void  wwvb_last  ( UBYTE*,UBYTE*,UBYTE*,UBYTE* ) ; /* Returen state machine states   */
extern void  wwvbsm     ( void )                        ; /* The time getting state machine */
extern void  wwvlsc     ( void )                        ; /* Check for leap seconds         */