/****************************************************************************
* transition.h
*
	Last change: ETC 12/24/2007 9:17:37 AM
****************************************************************************/

/* Definitions for transition types                                    */
/* TR_COPY just copies the data ASAP, a cut in movie-speak             */
/* TR_SCROLL scrolls the new content in, scrolling the old content out */
/* TR_WIPE1 does a wipe in movie-speak, replacing new with old         */
/* TR_WIPE2 is a wipe too, but has a line at the wipe transition       */
#define TR_CUT 0
#define TR_SCROLL 1
#define TR_WIPE1 2
#define TR_WIPE2 3

/* Definitions for transition directions */
/* for cuts */
#define TR_FAST 0
#define TR_FLASH 1
#define TR_BLINK 2
/* for wipes */
#define TR_UP 0
#define TR_DOWN 1
#define TR_LEFT 2
#define TR_RIGHT 3

/* Definitions for which lines to transition */
/* don't mess with values, I use bit values in assembly code! */
#define TR_LINE1 1
#define TR_LINE2 2
#define TR_LINE12 3

/* For new time-drawing, pick "normal" or fancy modes */
/*   Normal is just a quick redraw of the time        */
/*   Fancy changes the transition based on minute.    */
#define TRT_NORMAL 0
#define TRT_FANCY 1

extern void transition( UBYTE,UBYTE,UBYTE,UBYTE) ; /* Transitions from standby to active matrix */
extern void transition_engine( void )            ; /* Transition engine */

