/*                                         Copyright (c) CMI Productions, 2007
 *****************************************************************************
 *  tables.c
 *
 *  Data tables
 ****EXTERNAL*****************************************************************
 * oneofeight : one successive bit set for each byte
 * barcode : successive bits set from 1 to 8 bits
 * days_per_month : Number of days in each month (leap years calculated)
 * keytable : decoder ring for key decoding 
 * ticks : Default value for hours array to light up the tick marks
 * hrled : Used to figure out which LED to light for hours (see text)
 * matrix_char_map: 5x8 matrix for all 96 printable characters
 ****INTERNAL*****************************************************************
 * 
 *****************************************************************************
*/

#include "def.h"
#include "gpio.h"
#include "transition.h"
#include "tables.h"

/* this decodes an 3-bit value to a one-of-eight sequence */
const UBYTE oneofeight[8] = {0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80} ;

/* Same as above,but progressively set bits */
const UBYTE barcode[8] = {0x01,0x03,0x07,0x0f,0x1f,0x3f,0x7f,0xff} ;

/* days_per_month : Number of days in each month (leap years calculated later */
const UBYTE days_per_month[12] = {31,28,31,30,31,30,31,31,30,31,30,31} ;

/* This is the decoder ring that translates the data from the four */
/* GPIO lines for keys into a key code.  With four lines there are */
/* 16 possible combinations.  Multiple keys being pressed are      */
/* ignored, so only the four legit values return a vaild keycode.  */
const UBYTE keytable[16] = {
   KEY_NONE,   /* 0000 = All four keys pressed (conflict) */
   KEY_NONE,   /* 0001 = (conflict) */
   KEY_NONE,   /* 0010 = (conflict) */
   KEY_NONE,   /* 0011 = (conflict) */
   KEY_NONE,   /* 0100 = (conflict) */
   KEY_NONE,   /* 0101 = (conflict) */
   KEY_NONE,   /* 0110 = (conflict) */
   KEY_MENU,   /* 0111 = MENU key   */
   KEY_NONE,   /* 1000 = (conflict) */
   KEY_NONE,   /* 1001 = (conflict) */
   KEY_NONE,   /* 1010 = (conflict) */
   KEY_ENTER,  /* 1011 = ENTER key */
   KEY_NONE,   /* 1100 = (conflict) */
   KEY_DOWN,   /* 1101 = DOWN key   */
   KEY_UP,     /* 1110 = UP key     */
   KEY_NONE} ; /* 1111 = No keys    */

/* ticks : Default value for hours array to light up the tick marks */
const UBYTE ticks[8] = {0x21, 0x84, 0x10, 0x42, 0x08, 0x21, 0x84, 0x00} ;


/* Transition table, 15 entries for every quarter hour */
const UBYTE trtbl[15][2] = {
   {TR_CUT,    TR_FAST } ,
   {TR_CUT,    TR_FLASH} ,
   {TR_CUT,    TR_BLINK} ,
   {TR_SCROLL, TR_UP   } , 
   {TR_SCROLL, TR_DOWN } , 
   {TR_SCROLL, TR_LEFT } , 
   {TR_SCROLL, TR_RIGHT} , 
   {TR_WIPE1,  TR_UP   } , 
   {TR_WIPE1,  TR_DOWN } , 
   {TR_WIPE1,  TR_LEFT } , 
   {TR_WIPE1,  TR_RIGHT} , 
   {TR_WIPE2,  TR_UP   } , 
   {TR_WIPE2,  TR_DOWN } , 
   {TR_WIPE2,  TR_LEFT } , 
   {TR_WIPE2,  TR_RIGHT} } ;

/* This is the array that says what bit in what byte to light for the hours. */
/* 48 entries for each quarter hour.  Byte 1 is index to byte, Byte 2 is bit to light */
const UBYTE hrled[48][2] = {
   { 0,0x02 }, // 12:00
   { 0,0x04 }, // 12:15
   { 0,0x08 }, // 12:30
   { 0,0x10 }, // 12:45
   { 0,0x40 }, //  1:00
   { 0,0x80 }, //  1:15
   { 1,0x01 }, //  1:30
   { 1,0x02 }, //  1:45
   { 1,0x08 }, //  2:00
   { 1,0x10 }, //  2:15
   { 1,0x20 }, //  2:30
   { 1,0x40 }, //  2:45
   { 2,0x01 }, //  3:00
   { 2,0x02 }, //  3:15
   { 2,0x04 }, //  3:30
   { 2,0x08 }, //  3:45
   { 2,0x20 }, //  4:00
   { 2,0x40 }, //  4:15
   { 2,0x80 }, //  4:30
   { 3,0x01 }, //  4:45
   { 3,0x04 }, //  5:00
   { 3,0x08 }, //  5:15
   { 3,0x10 }, //  5:30
   { 3,0x20 }, //  5:45
   { 3,0x80 }, //  6:00
   { 4,0x01 }, //  6:15
   { 4,0x02 }, //  6:30
   { 4,0x04 }, //  6:45
   { 4,0x10 }, //  7:00
   { 4,0x20 }, //  7:15
   { 4,0x40 }, //  7:30
   { 4,0x80 }, //  7:45
   { 5,0x02 }, //  8:00
   { 5,0x04 }, //  8:15
   { 5,0x08 }, //  8:30
   { 5,0x10 }, //  8:45
   { 5,0x40 }, //  9:00
   { 5,0x80 }, //  9:15
   { 6,0x01 }, //  9:30
   { 6,0x02 }, //  9:45
   { 6,0x08 }, // 10:00
   { 6,0x10 }, // 10:15
   { 6,0x20 }, // 10:30
   { 6,0x40 }, // 10:45
   { 7,0x01 }, // 11:00
   { 7,0x02 }, // 11:15
   { 7,0x04 }, // 11:30
   { 7,0x08 }, // 11:45
   } ;

/****************************************************************************
*  5x8 LED matrix character map for printable characters.
*  Eight bytes, one for each row starting with the top row.
*  Five LSBs matter, LSB is right-most bit.
*  Bit value of 1 means LED on, 0 means LED off.
****************************************************************************/

const unsigned char matrix_char_map[96][8] = {
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, // ASCII " "
   {0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x04, 0x00}, // ASCII "!"
   {0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00}, // ASCII """
   {0x00, 0x0a, 0x1f, 0x0a, 0x1f, 0x0a, 0x00, 0x00}, // ASCII "#"
   {0x04, 0x0e, 0x15, 0x0e, 0x15, 0x0e, 0x04, 0x00}, // ASCII "$"
   {0x00, 0x10, 0x0a, 0x04, 0x0a, 0x01, 0x00, 0x00}, // ASCII "%"
   {0x0e, 0x11, 0x11, 0x0e, 0x0a, 0x11, 0x1e, 0x00}, // ASCII "&"
   {0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00}, // ASCII "'"
   {0x08, 0x04, 0x02, 0x02, 0x02, 0x04, 0x08, 0x00}, // ASCII "("
   {0x02, 0x04, 0x08, 0x08, 0x08, 0x04, 0x02, 0x00}, // ASCII ")"
   {0x00, 0x15, 0x0e, 0x1f, 0x0e, 0x15, 0x00, 0x00}, // ASCII "*"
   {0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00, 0x00}, // ASCII "+"
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00}, // ASCII ","
   {0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00}, // ASCII "-"
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00}, // ASCII "."
   {0x00, 0x10, 0x08, 0x04, 0x02, 0x01, 0x00, 0x00}, // ASCII "/"
   {0x0e, 0x11, 0x19, 0x15, 0x13, 0x11, 0x0e, 0x00}, // ASCII "0"
   {0x04, 0x06, 0x04, 0x04, 0x04, 0x04, 0x0e, 0x00}, // ASCII "1"
   {0x0e, 0x11, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00}, // ASCII "2"
   {0x0e, 0x11, 0x10, 0x0c, 0x10, 0x11, 0x0e, 0x00}, // ASCII "3"
   {0x11, 0x11, 0x11, 0x1e, 0x10, 0x10, 0x10, 0x00}, // ASCII "4"
   {0x1f, 0x01, 0x01, 0x0f, 0x10, 0x11, 0x0e, 0x00}, // ASCII "5"
   {0x0e, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x0e, 0x00}, // ASCII "6"
   {0x1f, 0x10, 0x10, 0x08, 0x04, 0x04, 0x04, 0x00}, // ASCII "7"
   {0x0e, 0x11, 0x11, 0x0e, 0x11, 0x11, 0x0e, 0x00}, // ASCII "8"
   {0x0e, 0x11, 0x11, 0x1e, 0x10, 0x08, 0x04, 0x00}, // ASCII "9"
   {0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00}, // ASCII ":"
   {0x00, 0x00, 0x04, 0x00, 0x04, 0x02, 0x00, 0x00}, // ASCII ";"
   {0x08, 0x04, 0x02, 0x01, 0x02, 0x04, 0x08, 0x00}, // ASCII "<"
   {0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00, 0x00}, // ASCII "="
   {0x02, 0x04, 0x08, 0x10, 0x08, 0x04, 0x02, 0x00}, // ASCII ">"
   {0x0e, 0x11, 0x09, 0x04, 0x04, 0x00, 0x04, 0x00}, // ASCII "?"
   {0x0e, 0x15, 0x1b, 0x1b, 0x0b, 0x15, 0x0e, 0x00}, // ASCII "@"
   {0x0e, 0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x00}, // ASCII "A"
   {0x0f, 0x11, 0x11, 0x0f, 0x11, 0x11, 0x0f, 0x00}, // ASCII "B"
   {0x0e, 0x11, 0x01, 0x01, 0x01, 0x11, 0x0e, 0x00}, // ASCII "C"
   {0x0f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0f, 0x00}, // ASCII "D"
   {0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x1f, 0x00}, // ASCII "E"
   {0x1f, 0x01, 0x01, 0x0f, 0x01, 0x01, 0x01, 0x00}, // ASCII "F"
   {0x0e, 0x11, 0x01, 0x1d, 0x11, 0x11, 0x0e, 0x00}, // ASCII "G"
   {0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11, 0x00}, // ASCII "H"
   {0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f, 0x00}, // ASCII "I"
   {0x1f, 0x08, 0x08, 0x08, 0x09, 0x09, 0x06, 0x00}, // ASCII "J"
   {0x11, 0x09, 0x05, 0x03, 0x05, 0x09, 0x11, 0x00}, // ASCII "K"
   {0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00}, // ASCII "L"
   {0x11, 0x1b, 0x15, 0x15, 0x11, 0x11, 0x11, 0x00}, // ASCII "M"
   {0x11, 0x11, 0x13, 0x15, 0x19, 0x11, 0x11, 0x00}, // ASCII "N"
   {0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00}, // ASCII "O"
   {0x0f, 0x11, 0x11, 0x0f, 0x01, 0x01, 0x01, 0x00}, // ASCII "P"
   {0x0e, 0x11, 0x11, 0x11, 0x15, 0x19, 0x1e, 0x00}, // ASCII "Q"
   {0x0f, 0x11, 0x11, 0x0f, 0x05, 0x09, 0x11, 0x00}, // ASCII "R"
   {0x0e, 0x11, 0x01, 0x0e, 0x10, 0x11, 0x0e, 0x00}, // ASCII "S"
   {0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00}, // ASCII "T"
   {0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e, 0x00}, // ASCII "U"
   {0x11, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x04, 0x00}, // ASCII "V"
   {0x11, 0x11, 0x15, 0x15, 0x15, 0x15, 0x0a, 0x00}, // ASCII "W"
   {0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11, 0x00}, // ASCII "X"
   {0x11, 0x11, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x00}, // ASCII "Y"
   {0x1f, 0x10, 0x08, 0x04, 0x02, 0x01, 0x1f, 0x00}, // ASCII "Z"
   {0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00}, // ASCII "["
   {0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x00, 0x00}, // ASCII "\"
   {0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x00}, // ASCII "]"
   {0x04, 0x0a, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00}, // ASCII "^"
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00}, // ASCII "_"
   {0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00}, // ASCII "`"
   {0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x1c, 0x00}, // ASCII "a"
   {0x02, 0x02, 0x0e, 0x12, 0x12, 0x12, 0x0e, 0x00}, // ASCII "b"
   {0x00, 0x00, 0x0c, 0x12, 0x02, 0x12, 0x0c, 0x00}, // ASCII "c"
   {0x10, 0x10, 0x1c, 0x12, 0x12, 0x12, 0x1c, 0x00}, // ASCII "d"
   {0x00, 0x00, 0x0c, 0x1e, 0x02, 0x12, 0x0c, 0x00}, // ASCII "e"
   {0x08, 0x14, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x00}, // ASCII "f"
   {0x00, 0x0c, 0x12, 0x12, 0x1c, 0x12, 0x0c, 0x00}, // ASCII "g"
   {0x02, 0x02, 0x0e, 0x12, 0x12, 0x12, 0x12, 0x00}, // ASCII "h"
   {0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00}, // ASCII "i"
   {0x00, 0x08, 0x00, 0x08, 0x08, 0x08, 0x06, 0x00}, // ASCII "j"
   {0x02, 0x02, 0x0a, 0x06, 0x06, 0x0a, 0x12, 0x00}, // ASCII "k"
   {0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00}, // ASCII "l"
   {0x00, 0x00, 0x0b, 0x15, 0x15, 0x15, 0x15, 0x00}, // ASCII "m"
   {0x00, 0x00, 0x0e, 0x12, 0x12, 0x12, 0x12, 0x00}, // ASCII "n"
   {0x00, 0x00, 0x0c, 0x12, 0x12, 0x12, 0x0c, 0x00}, // ASCII "o"
   {0x00, 0x0e, 0x12, 0x12, 0x0e, 0x02, 0x02, 0x00}, // ASCII "p"
   {0x00, 0x1c, 0x12, 0x12, 0x1c, 0x10, 0x10, 0x00}, // ASCII "q"
   {0x00, 0x00, 0x0e, 0x12, 0x02, 0x02, 0x02, 0x00}, // ASCII "r"
   {0x00, 0x00, 0x1c, 0x02, 0x0c, 0x10, 0x0e, 0x00}, // ASCII "s"
   {0x00, 0x00, 0x04, 0x0e, 0x04, 0x04, 0x04, 0x00}, // ASCII "t"
   {0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x1c, 0x00}, // ASCII "u"
   {0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x0c, 0x00}, // ASCII "v"
   {0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x0a, 0x00}, // ASCII "w"
   {0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x00}, // ASCII "x"
   {0x00, 0x14, 0x14, 0x14, 0x08, 0x04, 0x02, 0x00}, // ASCII "y"
   {0x00, 0x00, 0x1e, 0x08, 0x04, 0x02, 0x1e, 0x00}, // ASCII "z"
   {0x08, 0x04, 0x04, 0x02, 0x04, 0x04, 0x08, 0x00}, // ASCII "{"
   {0x04, 0x04, 0x04, 0x00, 0x04, 0x04, 0x04, 0x00}, // ASCII "|"
   {0x02, 0x04, 0x04, 0x08, 0x04, 0x04, 0x02, 0x00}, // ASCII "}"
   {0x00, 0x14, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00}  // ASCII "~"
   };

/* This is the table of possible time names and offsets.  Since   */
/* the timezone names are different lengths, I also have starting */
/* coordinates on where to write out the timezone on line 2.      */
const tz_table_t tz_table[7] = {
   {6,8,(UBYTE*)"AST" , -4}, 
   {6,8,(UBYTE*)"EST" , -5}, 
   {6,8,(UBYTE*)"CST" , -6}, 
   {6,8,(UBYTE*)"MST" , -7}, 
   {6,8,(UBYTE*)"PST" , -8}, 
   {3,8,(UBYTE*)"AKST", -9}, 
   {3,8,(UBYTE*)"HAST",-10}  
   } ;

