/*                                        Copyright (c) CMI Productions, 2007
 *****************************************************************************
 *  globals.c
 *
 *  Global variables
 ****EXTERNAL*****************************************************************
 * clkmtx : The three rings of LEDs
 * dspmtx : The inner 30x16 matrix of LEDs
 ****INTERNAL*****************************************************************
 * 
 *****************************************************************************
*/

#include "def.h"

/* See the file "LED Matrix.txt" for the memory structure */
UBYTE clkmtxa[16]; /* The clock LEDs-phase a  */
UBYTE dspmtxa[64]; /* The matrix LEDs-phase a */
UBYTE clkmtxb[16]; /* The clock LEDs-phase b  */
UBYTE dspmtxb[64]; /* The matrix LEDs-phase b */

UBYTE dspstga[64]; /* Staging data for matrix-phase a */
UBYTE dspstgb[64]; /* Staging data for matrix-phase b */

/* The time */
UBYTE thold  ; /* Time hold             */
UBYTE ssecs  ; /* Sub-seconds (1/60ths) */
UBYTE secs   ; /* Seconds               */
UBYTE mins   ; /* Minutes               */
UBYTE hrs    ; /* Hours                 */
UBYTE day    ; /* Day                   */
UBYTE month  ; /* Month                 */
UBYTE year   ; /* Year                  */
UBYTE newmin ; /* New minute flag       */

/* The current key being pressed (this auto-repeats when needed) */
/* App that "uses" the keypress should set to KEY_NONE after use */
UBYTE curkey ;

/* This is a flag to turn off the display.  I need this to be    */
/* able to listen to the WWVB radio.                             */
UBYTE doff ;

/* This is simply a count that inrements every 50ms to help with */
/* timing routines that need to be sync'd to the display refresh */
UBYTE tim50ms ;

/* Semaphore info for the transition engine */
UBYTE transition_busy ;
UBYTE transition_type ;
UBYTE transition_direction ;
UBYTE transition_lines ;

/* some globals for WWVB time setting */
UBYTE wwvb_led    ; /* the state for the LED showing the WWVB signal       */
UBYTE wwv_pa      ; /* Bit 5 of the radio enable bit (default disabled)    */
UBYTE dstflag     ; /* DST live transition flag.                           */
UBYTE nsecs       ; /* Number of seconds in this minute (for leap seconds) */
