/****************************************************************************
* timer.h
*
****************************************************************************/
void ledtimer_init( void );
void interrupt tmr2_isr( void );
void showtime ( UBYTE) ;
void del50ms ( UBYTE, UBYTE ) ;

/* OFF     = don't show the time                            */
/* PLAIN   = outer ring is minutes and seconds only         */
/* SSMODE1 = show single chasing LED for 60ths of a second  */
/* SSMODE2 = show dual chasing LEDs in opposite directions  */
/* SSMODE3 = show single LED buncing back and forth         */
/* SSMODE4 = show incrementing seconds as "bargraph"        */
/* SSSEQ   = Sequence thorugh all five modes above          */
/* SETHRS  = show time in plain mode, with hours blinking   */
/* SETMINS = show time in plain mode, with minutes blinking */
/* SETMONTH= show time in plain mode, with month blinking   */
/* SETDAY  = show time in plain mode, with day blinking     */
/* SETYEAR = show time in plain mode, with year blinking    */
#define SHOWTIME_OFF 0
#define SHOWTIME_PLAIN 1
#define SHOWTIME_SSMODE1 2
#define SHOWTIME_SSMODE2 3
#define SHOWTIME_SSMODE3 4
#define SHOWTIME_SSMODE4 5
#define SHOWTIME_SSSEQ 6
#define SHOWTIME_SETHRS  7
#define SHOWTIME_SETMINS 8
#define SHOWTIME_SETMONTH 9
#define SHOWTIME_SETDAY 10
#define SHOWTIME_SETYEAR 11

/* for the delay call, there are two modes          */
/* DEL_NOW  Delay # of 50us ticks from being called */
/* DEL_LAST Delay # of 50us ticks from last call    */
#define DEL_NOW 0
#define DEL_LAST 1
