/****************************************************************************
* tables.h
*
****************************************************************************/

/* big tables of data that are best in their own file */
extern UBYTE oneofeight[8]          ; /* Simple array get a one-of-eight decode   */
extern UBYTE barcode[8]             ; /* Successive bit set from 1 to 8 bits */
extern UBYTE days_per_month[12]     ; /* days in each month of the year (feb computed seperately) */
extern UBYTE keytable[16]           ; /* port-to-keycode decoder table */
extern UBYTE ticks[8]               ; /* Values to put in the hours array to fill in ticks */
extern UBYTE trtbl[15][2]           ; /* transition table for times */
extern UBYTE hrled[48][2]           ; /* Byte #/Byte value to fill in for each quarter hour */
extern UBYTE matrix_char_map[96][8] ; /* All 96 printable characters */

typedef struct {
   UBYTE  x,y    ; /* where to write timezone text */
   UBYTE* text   ; /* timezone text                */
   BYTE   offset ; /* timezone offset              */
   } tz_table_t ;

extern tz_table_t tz_table[7] ;
