/****************************************************************************
* asmhelp.h
*
*****************************************************************************
*
* These are the assembly language helper routines
*
* send_clk : Send the outer ring data 
* send_mtx : Send matrix data
* bfshift  : Bit field shift right
* xshfitl  : Shift data from standby array to active array one pixel left
* xshfitr  : Shift data from standby array to active array one pixel right
* aldir    : C access to Z80 LDIR instruction (quick copies)
* alddr    : C access to Z80 LDDR instruction (quick copies)
*
*/

extern void send_clk(UBYTE);
extern void wrchr(UBYTE*,UBYTE*,UBYTE) ;
extern void bfshift(UBYTE*,UBYTE) ;
extern void xshiftl(UBYTE) ;
extern void xshiftr(UBYTE) ;
extern void aldir(UBYTE*,UBYTE*,UWORD) ;
extern void alddr(UBYTE*,UBYTE*,UWORD) ;
extern void rlmem(UBYTE ,UBYTE*,UBYTE) ;
