/****************************************************************************
* LedMatrix.h
*
	Last change: ETC 12/24/2007 9:17:37 AM
****************************************************************************/

/* The phases to write to (for blinking) */
/* I also define BLINK and STEADY as phases generally won't matter */
#define PHASEA 1
#define PHASEB 2
#define PHASEAB 3
#define BLINK 1
#define STEADY 3

/* Most drawing commands can draw to either the active (being displayed) */
/* plane or the standby plane to get shifted/merged to the active plane. */
#define ACTIVE_PLANE 0
#define STANDBY_PLANE 1

/* eZ80 development board led matrix functions */
extern void ledmatrix_init     ( void )                          ; /* Initialize hardware        */
extern void ledmatrix_clear    ( UBYTE )                         ; /* clear display (LEDs off)   */
extern void ledmatrix_cline    ( UBYTE,UBYTE )                   ; /* clear a line (LEDs off)    */
extern void ledmatrix_pattern  ( UBYTE )                         ; /* set display pattern        */
extern void ledmatrix_led_test ( void )                          ; /* power-up LED test pattern  */
extern void ledmatrix_putc     ( UBYTE,UBYTE,UBYTE,UBYTE,UBYTE ) ; /* Display a single character */
extern void ledmatrix_puts     ( UBYTE,UBYTE,UBYTE*,UBYTE,UBYTE ); /* display a string           */

extern void ledmatrix_bset     ( UBYTE,UBYTE,UBYTE )       ; /* Simple wait                */
extern void ledmatrix_bclr     ( UBYTE,UBYTE,UBYTE )       ; /* Simple wait                */

extern void ledmatrix_wrtime   ( UBYTE,UBYTE )             ; /* write time to matrix       */
extern void ledmatrix_wryear   ( UBYTE )                   ; /* write year to matrix       */

