        page
******************************************************
** Copyright 2007 CMI Productions.                  **
** Lots of rights reserved.                         **
** Free for personal use as long as this copyright  **
** message is maintained in the source and the LCD  **
** copyright message is also preserved.  Commercial **
** use prohibited without CMIs written concent.     **
******************************************************
; -----------------------------------------------------------------------------
; File:         ui.asm
; Function:     User Interface for the clock
; Routines:     menus: Main menu traversing
;               stime: Set the time manually
;               gtime: Get the time from WWVB
;               ttime: Set test time (11:59:45) for midnight rollover
;               led
; -----------------------------------------------------------------------------
;
;       This file contains all the user interface menuing code.

        page
; -----------------------------------------------------------------------------
; Routine:      menus
; Called By:    main
; Calls:        None
; Gazintas:     None
; Gazoutas:     None
; Globals:      None
; Function:     This main menu program, called when the user hits the menu
;               button.  This sequences through the first tier of options:
;               SET WWVB: Set up WWVB parameters (TZ and DST)
;               GET WWVB: Manual WWVB reception
;               SET TIME: Manual time set
;               Only button acknowledged is the menu button to sequence through
;               options and enter to select that option.  If they get to the
;               end, I just go back to the time.
; -----------------------------------------------------------------------------
menus:  mov     #1,dsphld       ; stop showing the time
        jsr     dclr            ; clear the matrix
        jsr     tclr            ; clear the rings

        ldhx    #m_set          ; SET message
        jsr     dpmsg           ; display it
        ldhx    #m_wwl2         ; WWVB message
        jsr     dpmsg           ; display it

menus1: jsr     wfnkey          ; wait for next keypress
        cbeqa   #ksel,lwwvst    ; if select, to to WWVB settings routine
        cmp     #kmenu          ; see if Menu key
        bne     menus1          ; if anything else, wait

        jsr     dclr            ; clear the matrix
        ldhx    #m_get          ; GET message
        jsr     dpmsg           ; display it
        ldhx    #m_wwl2         ; WWVB message
        jsr     dpmsg           ; display it

menus2: jsr     wfnkey          ; wait for next keypress
        cbeqa   #ksel,lgtime    ; if select, to to WWVB acquisition routine
        cmp     #kmenu          ; see if Menu key
        bne     menus2          ; if anything else, wait

        jsr     dclr            ; clear the matrix
        ldhx    #m_set          ; SET message
        jsr     dpmsg           ; display it
        ldhx    #m_time         ; TIME message
        jsr     dpmsg           ; display it

menus3: jsr     wfnkey          ; wait for next keypress
        cbeqa   #ksel,lstime    ; if select, to time setting routine
        cmp     #kmenu          ; see if Menu key
        bne     menus3          ; if anything else, wait

menuex: jsr     wnokey          ; wait for no key pressed
        rts                     ; back to main

lwwvst: jsr     wwvset          ; go set the settings
        jsr     gtime           ; go re-get the time
        bra     menuex          ; and exit

lgtime: jsr     gtime           ; go set the settings
        bra     menuex          ; and exit

lstime: jsr     stime           ; go set the settings
        bra     menuex          ; and exit

        page
; -----------------------------------------------------------------------------
; Routine:      stime
; Called By:    menus
; Calls:        None
; Gazintas:     None
; Gazoutas:     month,day,year,hours,mins
; Function:     This is the routine to set the time.  We use the blink flag
;               to tell which field is being set.  Hours, minutes, month and
;               day are done using the regular display, then we create a new
;               display for the year.  Setting the rtchld flag stops the time
;               from incrementing and turns off the seconds and sub-seconds
;               display.  Much of this code is borrowed from the T238 project!
; -----------------------------------------------------------------------------
stime:  clr     dsphld          ; make sure we are showing the time
        clr     keycnt          ; clear key counter (for auto-repeat stuff)
        inc     rtchld          ; hold off RTC
        clr     cntr            ; our field pointer
stimw1: lda     curkey          ; get the current key
        cmp     #knone          ; see if no key yet
        bne     stimw1          ; wait until it is.

stlp:   ldx     cntr            ; our field pointer
        clrh                    ; make sure H is 0
        lda     stcol,x         ; get the field to blink
        sta     blink           ; make it so.

stscan: lda     curkey          ; get key pressed (if any)
        cmp     #kwait          ; see if wait code
        beq     stscan          ; no new data yet, wait
        cmp     #ksel           ; see if menu
        beq     stlext          ; if so, exit off to menus
        cmp     #knone          ; if no key, reset rapid count
        beq     strst           ; go do it
        cmp     #kup            ; see if up key
        beq     stupdn          ; go process
        cmp     #kdown          ; see if down key
        beq     stupdn          ; go do it if so

strst:  clr     keycnt          ; clear key pressed count
        bra     stscan          ; go wait for a key

stlext: jmp     llmenu          ; long jump

stupdn: lda     keycnt          ; get key counter
        beq     stdoit          ; if 0 value, go inc/dec by 1
        cmp     #11             ; see if 11 samples
        blo     stkwt           ; if 1-11, no action
        dec     keycnt          ; don't want keycnt to overflow
        ; At 10 counts (and holding), auto-increment/decrement

stdoit: lda     curkey          ; get keycode back again
        cmp     #kdown          ; see if down (vs up)
        beq     stdown          ; if so, go decrement time

stup:   ldx     cntr            ; get our counter
        clrh                    ; make sure H is 0
        ldx     stoff,x         ; point to real variable
        inc     mins,x          ; get the field to increment
        lda     mins,x          ; get incremented value
        cpx     #2              ; see if day of month
        bne     stupnf          ; if not, normal processing

        lda     month           ; get month
        ldx     year            ; get year
        jsr     mthmax          ; get max days in current month
        sta     temp            ; save it
        lda     day             ; get day back
        cmp     temp            ; do compare
        bra     stupfc          ; do checking

stupnf: ldx     cntr            ; get original pointer back
        cmp     stmax,x         ; compare to max value
stupfc: bls     stntim          ; if within limits, all done
        ldx     cntr            ; get our counter
        clrh                    ; make sure H is 0
        ldx     stoff,x         ; point to real variable
        lda     stmin,x         ; otherwise roll, get min value
        sta     mins,x          ; save as new value
        bra     stntim          ; all done

stdown: ldx     cntr            ; get our pointer
        clrh                    ; make sure H is 0
        ldx     stoff,x         ; point to real variable
        dec     mins,x          ; get the field to increment
        lda     mins,x          ; get incremented value
        bmi     stdnnn          ; if negative, we have underflowed
        ldx     cntr            ; get index back again
        cmp     stmin,x         ; compare to max value
        bhs     stntim          ; if within limits, all done
stdnnn: ldx     cntr            ; get index back
        clrh                    ; make sure H is 0
        lda     stmax,x         ; otherwise roll, get max value
        ldx     stoff,x         ; point back to variable to change
        sta     mins,x          ; save as new value
        cpx     #2              ; see if day of month
        bne     stntim          ; if not, normal processing

        lda     month           ; get month
        ldx     year            ; get year
        jsr     mthmax          ; get max days in current month
        sta     day             ; and save it.

stntim: inc     keycnt          ; increment our key counter
        lda     #kwait          ; wait for next scan flag
        sta     curkey          ; store it
lstlp:  jmp     stlp            ; go display new time

stkwt:  inc     keycnt          ; increment key count
        lda     #kwait          ; wait for next scan flag
        sta     curkey          ; store it
        jmp     stscan          ; wait for next scan

llmenu: lda     curkey          ; get current keycode
        cmp     #knone          ; see if no key
        bne     llmenu          ; wait for no key
        inc     cntr            ; if select pressed, increment counter
        lda     cntr            ; get incremented value
        cmp     #5              ; see if done
        bne     lstlp           ; if not, loop back, else done

stexit: clr     blink           ; no more blinkies
        clr     ssecs           ; restart sub-seconds
        clr     secs            ; restart seconds
        clr     rtchld          ; turn RTC back on
        rts                     ; all done

        page
; -----------------------------------------------------------------------------
; Routine:      gtime
; Called By:    menus
; Calls:        None
; Gazintas:     None
; Gazoutas:     month,day,year,hours,mins
; Function:     This is the routine to monitor getting the time from the WWVB
;               receiver.  All the work is done by the WWVB state machine, this
;               is just a mainline program to start the process, monitor it, and
;               return once the time is set.  It is used if the time isn't being
;               recieved in the background.
; -----------------------------------------------------------------------------
gtime:  mov     #1,dsphld       ; hold off time display
        jsr     dclr            ; clear the display center
        inc     wwvbst          ; fire off the state machine!

        ldhx    #m_wwvb         ; WWVB message
        jsr     dpmsg           ; display it

gtgtrs: jsr     dclr2           ; clear line 2
        jsr     tclr            ; clear outer ring
        ldhx    #m_sync         ; SYNC message
        jsr     dpmsg           ; display it
        clr     temp            ; our progress flag

gtgtlp: lda     wwvled          ; get the WWVB LED state
        sta     clkmtx+8        ; get clock display value (Phase A)
        sta     clkmty+8        ; get clock display value (Phase B)

        tst     temp            ; see if we are in sync or RX state
        bne     gtgtnt          ; if in RX state, go show progress

        lda     wwvbst          ; if in sync mode, get the state
        cmp     #4              ; see if we got to acquisition phase
        bne     gtgtck          ; if not, just check for abort before looping

;       Otherwise we just transitioned into the RX phase

        jsr     dclr2           ; clear line two
        ldhx    #m_rx1          ; RX1 message
        jsr     dpmsg           ; display it
        inc     temp            ; don't write it again

gtgtnt: lda     temp            ; see if we've written this state yet
        cmp     wwvbpt          ; get the bit pointer (counts 0-59)
        bhs     gtgtce          ; if already written, done
        jsr     tclr            ; clear the outer rings
        lda     wwvbpt          ; get bit counter state back
        sta     temp            ; remember it so we don't rewrite
        sta     secs            ; put it in the seconds location
        jsr     sssbar          ; so we can show progress

gtgtce: lda     wwvbst          ; get the WWVB state machine state
        cmp     #2              ; see if we reverted back to state 2
        beq     gtgtrs          ; if so, go back to sync message

gtgtck: lda     wwvbst          ; get the WWVB state machine state
        beq     gtgtex          ; if state 0, we're done!
        bra     gtgtlp          ; otherwise loop normally

gtgtex: clr     dsphld          ; start keeping time
        rts                     ; when WWVB state machine done, return!

        page
; -----------------------------------------------------------------------------
; Routine:      wwvset
; Called By:    menus
; Calls:        None
; Gazintas:     None
; Gazoutas:     TZ, DST
; Function:     This is the routine to set up the WWV parameters.  There are
;               only two, the timezone and DST observance
; -----------------------------------------------------------------------------
wwvset: lda     fitz            ; get the timezone
        sta     mndray          ; save it in RAM
        lda     fidso           ; get daylight savings observation from flash
        sta     mndray+1        ; save in RAM

        jsr     dclr            ; clear the display
        ldhx    #m_tzon         ; TZONE message
        jsr     dpmsg           ; display it

wwslp:  jsr     dclr2           ; clear out line 2
        ldx     mndray          ; get the time zone index
        aslx                    ; times two
        clrh                    ; H=0
        lda     tttbl,x         ; get index MSB
        ldx     tttbl+1,x       ; get LSB
        psha                    ; MSB on stack
        pulh                    ; now HX is text pointer
        jsr     dpmsg           ; show the selected time zone

wwsl1:  jsr     wfnkey          ; wait for next keypress
        cbeqa   #ksel,wwssl     ; if select, on to DST
        cbeqa   #kup,wwsup      ; if up, increment timezone
        cbeqa   #kdown,wwsdn    ; if down, decrement timezone
        bra     wwsl1           ; if anything else, wait

wwsup:  lda     mndray          ; get the time zone
        inca                    ; increment time zone
        sta     mndray          ; save it back
        cmp     #6              ; max valid value
        bls     wwslp           ; if not that, go show it
        clra                    ; 0...
        sta     mndray          ; otherwise cycle back to 0
        bra     wwslp           ; and show it

wwsdn:  lda     mndray          ; get the time zone
        deca                    ; decrement time zone
        sta     mndray          ; and save it
        bpl     wwslp           ; if >=0, go show it
        lda     #6              ; otherwise cycle back to 6
        sta     mndray          ; and save it
        bra     wwslp           ; and show it

;       Now for the DST observation flag

wwssl:  jsr     dclr            ; clear the display
        ldhx    #m_dst          ; DST? message
        jsr     dpmsg           ; display it

wwsdlp: jsr     dclr2           ; clear out line 2
        lda     mndray+1        ; get the flag (& set flags)
        bne     wwsddy          ; if not zero, yes
        ldhx    #m_no           ; otherwise no
        bra     wwsdsd          ; and show it
wwsddy: ldhx    #m_yes          ; Yes message
wwsdsd: jsr     dpmsg           ; show the selected time zone

wwsl2:  jsr     wfnkey          ; wait for next keypress
        cbeqa   #ksel,wwssv     ; if select, save settings
        cbeqa   #kup,wwsdsc     ; if up, change DST
        cbeqa   #kdown,wwsdsc   ; if down, change DST too
        bra     wwsl2           ; if anything else, wait

wwsdsc: lda     mndray+1        ; test the flag
        beq     wwsdsf          ; if true, set to false
        clra                    ; 0...
        sta     mndray+1        ; if false, set to true
        bra     wwsdlp          ; and go display it
wwsdsf: lda     #1              ; if true, set to false
        sta     mndray+1        ; store it
        bra     wwsdlp          ; and go display it

wwssv:  jsr     dclr            ; clear the display before disabling IRQs
        lda     ruftim          ; get the rough time counter
wwvdly: cmp     ruftim          ; wait for it to change (an IRQ processed)
        beq     wwvdly          ; wait...

        lda     #$ff            ; unused value
        sta     mndray+2        ; Leave unused bytes unprogrammed
        sta     mndray+3        ; Leave unused bytes unprogrammed
        sta     mndray+4        ; Leave unused bytes unprogrammed
        sta     mndray+5        ; Leave unused bytes unprogrammed
        sta     mndray+6        ; Leave unused bytes unprogrammed
        sta     mndray+7        ; Leave unused bytes unprogrammed

        sei                     ; interrupts off
        ldhx    #fpage0         ; page to erase
        jsr     appera          ; go earse it
        ldhx    #fitz           ; rain guage ID address
        jsr     apppgm          ; go program it
        cli                     ; interrupts back on!

        rts                     ; all done

        page
; -----------------------------------------------------------------------------
; Routine:      ttime
; Called By:    main menu
; Calls:        None
; Gazintas:     None
; Gazoutas:     None
; Function:     This just sets the time to 11:59pm local time so I can see the
;               WWVB engine do it's thing in the background
; -----------------------------------------------------------------------------
ttime:  clr     ssecs           ; The Time: 1/100ths of a second
        mov     #45,secs        ; The Time: seconds
        mov     #59,mins        ; The Time: minutes
        mov     #23,hrs         ; The Time: hours
        mov     #24,day         ; The Time: day of month
        mov     #4,month        ; The Time: month
        clr     year            ; The Time: year
        clr     rtchld          ; start the clock
        rts                     ; damage done, return!

        page
; -----------------------------------------------------------------------------
; Routine:      ledtst
; Called By:    main menu
; Calls:        None
; Gazintas:     None
; Gazoutas:     None
; Function:     This is simply a routine to light up the LEDs in sequence, a
;               sort-of lamp test. LEDs in the outer ring are light sequentially
;               from noon around through noon and then the matrix LEDs are lit
;               up from left to right.  I hold the "all LEDs on" pattern for
;               about a second then return.
; -----------------------------------------------------------------------------
ledtst: jsr     dclr            ; make sure matrix area is clear
        jsr     tclr            ; make sure time rings are clear
        tpa                     ; get default flag bits in A

ltlp1:  ldhx    #clkmtx         ; point to first byte in clock matrix
ltlp2:  tap                     ; get carry back
        rol     ,x              ; rotate a byte (Phase A)
        tpa                     ; save carry
        incx                    ; point to next byte (no overflow possible)
        cpx     #clkmtx+32      ; see if rotated all bytes
        bne     ltlp2           ; if not, loop
        bset    0,clkmtx        ; after rotation set LSB in outer array (Phase A)
        bset    0,clkmty        ; after rotation set LSB in outer array (Phase B)
        bset    0,clkmtx+8      ; after rotation set LSB in inner array (Phase A)
        bset    0,clkmty+8      ; after rotation set LSB in inner array (Phase B)

;       Use a phase change to capture a 50ms transition

        lda     phase           ; get the curent phase
ltlp3:  cmp     phase           ; compare with it again (waiting for it to change)
        beq     ltlp3           ; wait for it to change
        brclr   7,clkmtx+15,ltlp1 ; loop until all LEDs lit

;       Now repeat the whole thing again, this time for the LED matrix
;       display.

inlp4:  asl     dspmtx          ; shift first byte
        rol     dspmtx+1        ; rotate into 2nd byte
        rol     dspmtx+2        ; rotate into 3rd byte
        rol     dspmtx+3        ; rotate into 4th byte
        bset    0,dspmtx        ; set the LSB

        ldhx    #dspmtx         ; point to the array base
inlp4a: lda     ,x              ; get a source byte
        sta     4,x             ; copy it 4 bytes later
        incx                    ; point to next byte
        cpx     #dspmtx+60      ; see if copied all 64 bytes
        bne     inlp4a          ; loop till all done

        lda     phase           ; get the curent phase
ltlp4:  cmp     phase           ; compare with it again (waiting for it to change)
        beq     ltlp4           ; wait for it to change
        brclr   6,dspmtx+3,inlp4; loop till all bits shifted in

;       Cheesey way of doing a 1-second delay is to count 20 phase transitions
;       (50ms each)

        clrx                    ; 0...
inlp7:  lda     phase           ; get the curent phase
ltlp5:  cmp     phase           ; compare with it again (waiting for it to change)
        beq     ltlp5           ; wait for it to change

        incx                    ; increment our 50ms counter
        cpx     #20             ; 20 of them is one second
        bne     inlp7           ; do 20 of them

        rts                     ; all done

        page
; -----------------------------------------------------------------------------
; Routine:
; Called By:
; Calls:        None
; Gazintas:     None
; Gazoutas:     None
; Globals:      None
; Function:     This routine;
; -----------------------------------------------------------------------------

