        page
******************************************************
** Copyright 2007 CMI Productions.                  **
** Lots of rights reserved.                         **
** Free for personal use as long as this copyright  **
** message is maintained in the source and the LCD  **
** copyright message is also preserved.  Commercial **
** use prohibited without CMIs written concent.     **
******************************************************

keytbl: db      knone           ; 0000 = all four keys (conflict)
        db      knone           ; 0001 = (conflict)
        db      knone           ; 0010 = (conflict)
        db      knone           ; 0011 = (conflict)
        db      knone           ; 0100 = (conflict)
        db      knone           ; 0101 = (conflict)
        db      knone           ; 0110 = (conflict)
        db      kmenu           ; 0111 = Menu
        db      knone           ; 1000 = (conflict)
        db      knone           ; 1001 = (conflict)
        db      knone           ; 1010 = (conflict)
        db      ksel            ; 1011 = Enter
        db      knone           ; 1100 = (conflict)
        db      kdown           ; 1101 = Down
        db      kup             ; 1110 = Up
        db      knone           ; 1111 = None

rowtb1: db      $14,$24,$44,$84,$04,$04,$04,$04 ; Port A row values (with srclr* high)
rowtb2: db      $00,$00,$00,$00,$01,$02,$04,$08 ; Port D row values

;       These are the constants that convert the number of seconds per period
s_min:   db      $00,$00,$00,$3c ; 1 minute         =          60 seconds
s_hour:  db      $00,$00,$0e,$10 ; 1 hour           =       3,600 seconds
s_day:   db      $00,$01,$51,$80 ; 1 day            =      86,400 seconds
s_m28:   db      $00,$24,$ea,$00 ; 1 28-day month   =   2,419,200 seconds
s_m29:   db      $00,$26,$3b,$80 ; 1 29-day month   =   2,505,600 seconds
s_m30:   db      $00,$27,$8d,$00 ; 1 30-day month   =   2,592,000 seconds
s_m31:   db      $00,$28,$de,$80 ; 1 31-day month   =   2,678,400 seconds
s_y365:  db      $01,$e1,$33,$80 ; 1 365-day year   =  31,536,000 seconds
s_y366:  db      $01,$e2,$85,$00 ; 1 366-day year   =  31,622,400 seconds
s_y2k:   db      $38,$6d,$43,$80 ; 1/1/70 to 1/1/00 = 946,684,800 seconds

;       These are the tables for the time setting routine

mthtbl: db      31,28,31,30,31,30,31,31,30,31,30,31 ; days-in-month table
stcol:  db      $02,$01,$08,$04,$10 ; Blink flags for Hours, Minutes, Month, Day, year
stoff:  db      1,0,3,2,4        ; Index offset for hours, minutes, month, day, year
stmax:  db      23,59,12,31,99   ; Max values for hours, minutes, month, day, year
stmin:  db      0,0,1,1,0        ; Min values for hours, minutes, month, day, year

;       This is the table to figger out what symbol we got from WWVB based on the
;       number of low states we got.  See wwvsym for the tables entries

wwvsyt: db      wwvsnn          ; 0  =   0ms = nuthin
        db      wwvsxx          ; 1  =  50ms = illegal, gunk
        db      wwvsxx          ; 2  = 100ms = illegal, gunk
        db      wwvs0           ; 3  = 150ms = 0 bit
        db      wwvs0           ; 4  = 200ms = 0 bit
        db      wwvs0           ; 5  = 250ms = 0 bit
        db      wwvsxx          ; 6  = 300ms = illegal, gunk
        db      wwvsxx          ; 7  = 350ms = illegal, gunk
        db      wwvsxx          ; 8  = 400ms = illegal, gunk
        db      wwvs1           ; 9  = 450ms = 1 bit
        db      wwvs1           ; 10 = 500ms = 1 bit
        db      wwvs1           ; 11 = 550ms = 1 bit
        db      wwvsxx          ; 12 = 600ms = illegal, gunk
        db      wwvsxx          ; 13 = 650ms = illegal, gunk
        db      wwvsxx          ; 14 = 700ms = illegal, gunk
        db      wwvspm          ; 15 = 750ms = P marker bit
        db      wwvspm          ; 16 = 800ms = P marker bit
        db      wwvspm          ; 17 = 850ms = P marker bit

;       Table to convert seconds/minutes to LED location.  For each minute
;       (0-60), entry is byte offset and bit value to OR into the matrix
mintbl: db      0,$01 ; 00 minutes
        db      0,$02 ; 01 minutes
        db      0,$04 ; 02 minutes
        db      0,$08 ; 03 minutes
        db      0,$10 ; 04 minutes
        db      0,$20 ; 05 minutes
        db      0,$40 ; 06 minutes
        db      0,$80 ; 07 minutes

        db      1,$01 ; 08 minutes
        db      1,$02 ; 09 minutes
        db      1,$04 ; 10 minutes
        db      1,$08 ; 11 minutes
        db      1,$10 ; 12 minutes
        db      1,$20 ; 13 minutes
        db      1,$40 ; 14 minutes
        db      1,$80 ; 15 minutes

        db      2,$01 ; 16 minutes
        db      2,$02 ; 17 minutes
        db      2,$04 ; 18 minutes
        db      2,$08 ; 19 minutes
        db      2,$10 ; 20 minutes
        db      2,$20 ; 21 minutes
        db      2,$40 ; 22 minutes
        db      2,$80 ; 23 minutes

        db      3,$01 ; 24 minutes
        db      3,$02 ; 25 minutes
        db      3,$04 ; 26 minutes
        db      3,$08 ; 27 minutes
        db      3,$10 ; 28 minutes
        db      3,$20 ; 29 minutes
        db      3,$40 ; 30 minutes
        db      3,$80 ; 31 minutes

        db      4,$01 ; 32 minutes
        db      4,$02 ; 33 minutes
        db      4,$04 ; 34 minutes
        db      4,$08 ; 35 minutes
        db      4,$10 ; 36 minutes
        db      4,$20 ; 37 minutes
        db      4,$40 ; 38 minutes
        db      4,$80 ; 39 minutes

        db      5,$01 ; 40 minutes
        db      5,$02 ; 41 minutes
        db      5,$04 ; 42 minutes
        db      5,$08 ; 43 minutes
        db      5,$10 ; 44 minutes
        db      5,$20 ; 45 minutes
        db      5,$40 ; 46 minutes
        db      5,$80 ; 47 minutes

        db      6,$01 ; 48 minutes
        db      6,$02 ; 49 minutes
        db      6,$04 ; 50 minutes
        db      6,$08 ; 51 minutes
        db      6,$10 ; 52 minutes
        db      6,$20 ; 53 minutes
        db      6,$40 ; 54 minutes
        db      6,$80 ; 55 minutes

        db      7,$01 ; 56 minutes
        db      7,$02 ; 57 minutes
        db      7,$04 ; 58 minutes
        db      7,$08 ; 59 minutes

        db      0,$01 ; 60 minutes (used for leap seconds!)

;       Table to add the 15-minute increments to the hours value so we can
;       get quarter hour marks.  Simple a table with 15-each entries of 0-3
;       Might be easier/faster to divide minutes by 15???
qhrtbl: db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        db      1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
        db      2,2,2,2,2,2,2,2,2,2,2,2,2,2,2
        db      3,3,3,3,3,3,3,3,3,3,3,3,3,3,3


;       Default value for the Hours array that turns on the tick marks.
tckmtx: db      $21,$84,$10,$42,$08,$21,$84,$00

;       Table to convert quarter-hours into LED locations.  Have 48 entries.
;       Table is offset and bit value to OR into the hours table.  Messy as
;       I have to take into account the tick marks
hrstbl: db      0,$02 ; 12:00
        db      0,$04 ; 12:15
        db      0,$08 ; 12:30
        db      0,$10 ; 12:45
        db      0,$40 ;  1:00
        db      0,$80 ;  1:15
        db      1,$01 ;  1:30
        db      1,$02 ;  1:45
        db      1,$08 ;  2:00
        db      1,$10 ;  2:15
        db      1,$20 ;  2:30
        db      1,$40 ;  2:45
        db      2,$01 ;  3:00
        db      2,$02 ;  3:15
        db      2,$04 ;  3:30
        db      2,$08 ;  3:45
        db      2,$20 ;  4:00
        db      2,$40 ;  4:15
        db      2,$80 ;  4:30
        db      3,$01 ;  4:45
        db      3,$04 ;  5:00
        db      3,$08 ;  5:15
        db      3,$10 ;  5:30
        db      3,$20 ;  5:45
        db      3,$80 ;  6:00
        db      4,$01 ;  6:15
        db      4,$02 ;  6:30
        db      4,$04 ;  6:45
        db      4,$10 ;  7:00
        db      4,$20 ;  7:15
        db      4,$40 ;  7:30
        db      4,$80 ;  7:45
        db      5,$02 ;  8:00
        db      5,$04 ;  8:15
        db      5,$08 ;  8:30
        db      5,$10 ;  8:45
        db      5,$40 ;  9:00
        db      5,$80 ;  9:15
        db      6,$01 ;  9:30
        db      6,$02 ;  9:45
        db      6,$08 ; 10:00
        db      6,$10 ; 10:15
        db      6,$20 ; 10:30
        db      6,$40 ; 10:45
        db      7,$01 ; 11:00
        db      7,$02 ; 11:15
        db      7,$04 ; 11:30
        db      7,$08 ; 11:45

; Bitmap table for ASCII text

asctbl: db      $00,$00,$00,$00,$00,$00,$00,$00 ; ASCII " "
        db      $04,$04,$04,$04,$04,$00,$04,$00 ; ASCII "!"
        db      $0a,$0a,$0a,$00,$00,$00,$00,$00 ; ASCII """
        db      $00,$0a,$1f,$0a,$1f,$0a,$00,$00 ; ASCII "#"
        db      $04,$0e,$15,$0e,$15,$0e,$04,$00 ; ASCII "$"
        db      $00,$10,$0a,$04,$0a,$01,$00,$00 ; ASCII "%"
        db      $0e,$11,$11,$0e,$0a,$11,$1e,$00 ; ASCII "&"
        db      $04,$04,$04,$00,$00,$00,$00,$00 ; ASCII "'"
        db      $08,$04,$02,$02,$02,$04,$08,$00 ; ASCII "("
        db      $02,$04,$08,$08,$08,$04,$02,$00 ; ASCII ")"
        db      $00,$15,$0e,$1f,$0e,$15,$00,$00 ; ASCII "*"
        db      $00,$04,$04,$1f,$04,$04,$00,$00 ; ASCII "+"
        db      $00,$00,$00,$00,$00,$04,$02,$00 ; ASCII ","
        db      $00,$00,$00,$1f,$00,$00,$00,$00 ; ASCII "-"
        db      $00,$00,$00,$00,$00,$00,$04,$00 ; ASCII "."
        db      $00,$10,$08,$04,$02,$01,$00,$00 ; ASCII "/"
        db      $0e,$11,$19,$15,$13,$11,$0e,$00 ; ASCII "0"
        db      $04,$06,$04,$04,$04,$04,$0e,$00 ; ASCII "1"
        db      $0e,$11,$08,$04,$02,$01,$1f,$00 ; ASCII "2"
        db      $0e,$11,$10,$0c,$10,$11,$0e,$00 ; ASCII "3"
        db      $11,$11,$11,$1e,$10,$10,$10,$00 ; ASCII "4"
        db      $1f,$01,$01,$0f,$10,$11,$0e,$00 ; ASCII "5"
        db      $0e,$01,$01,$0f,$11,$11,$0e,$00 ; ASCII "6"
        db      $1f,$10,$10,$08,$04,$04,$04,$00 ; ASCII "7"
        db      $0e,$11,$11,$0e,$11,$11,$0e,$00 ; ASCII "8"
        db      $0e,$11,$11,$1e,$10,$08,$04,$00 ; ASCII "9"
        db      $00,$00,$04,$00,$04,$00,$00,$00 ; ASCII ":"
        db      $00,$00,$04,$00,$04,$02,$00,$00 ; ASCII ";"
        db      $08,$04,$02,$01,$02,$04,$08,$00 ; ASCII "<"
        db      $00,$00,$1f,$00,$1f,$00,$00,$00 ; ASCII "="
        db      $02,$04,$08,$10,$08,$04,$02,$00 ; ASCII ">"
        db      $0e,$11,$09,$04,$04,$00,$04,$00 ; ASCII "?"
        db      $0e,$15,$1b,$1b,$0b,$15,$0e,$00 ; ASCII "@"
        db      $0e,$11,$11,$11,$1f,$11,$11,$00 ; ASCII "A"
        db      $0f,$11,$11,$0f,$11,$11,$0f,$00 ; ASCII "B"
        db      $0e,$11,$01,$01,$01,$11,$0e,$00 ; ASCII "C"
        db      $0f,$11,$11,$11,$11,$11,$0f,$00 ; ASCII "D"
        db      $1f,$01,$01,$0f,$01,$01,$1f,$00 ; ASCII "E"
        db      $1f,$01,$01,$0f,$01,$01,$01,$00 ; ASCII "F"
        db      $0e,$11,$01,$1d,$11,$11,$0e,$00 ; ASCII "G"
        db      $11,$11,$11,$1f,$11,$11,$11,$00 ; ASCII "H"
        db      $1f,$04,$04,$04,$04,$04,$1f,$00 ; ASCII "I"
        db      $1f,$08,$08,$08,$09,$09,$06,$00 ; ASCII "J"
        db      $11,$09,$05,$03,$05,$09,$11,$00 ; ASCII "K"
        db      $01,$01,$01,$01,$01,$01,$1f,$00 ; ASCII "L"
        db      $11,$1b,$15,$15,$11,$11,$11,$00 ; ASCII "M"
        db      $11,$11,$13,$15,$19,$11,$11,$00 ; ASCII "N"
        db      $0e,$11,$11,$11,$11,$11,$0e,$00 ; ASCII "O"
        db      $0f,$11,$11,$0f,$01,$01,$01,$00 ; ASCII "P"
        db      $0e,$11,$11,$11,$15,$19,$1e,$00 ; ASCII "Q"
        db      $0f,$11,$11,$0f,$05,$09,$11,$00 ; ASCII "R"
        db      $0e,$11,$01,$0e,$10,$11,$0e,$00 ; ASCII "S"
        db      $1f,$04,$04,$04,$04,$04,$04,$00 ; ASCII "T"
        db      $11,$11,$11,$11,$11,$11,$0e,$00 ; ASCII "U"
        db      $11,$11,$11,$11,$11,$0a,$04,$00 ; ASCII "V"
        db      $11,$11,$15,$15,$15,$15,$0a,$00 ; ASCII "W"
        db      $11,$11,$0a,$04,$0a,$11,$11,$00 ; ASCII "X"
        db      $11,$11,$0a,$04,$04,$04,$04,$00 ; ASCII "Y"
        db      $1f,$10,$08,$04,$02,$01,$1f,$00 ; ASCII "Z"
        db      $07,$01,$01,$01,$01,$01,$07,$00 ; ASCII "["
        db      $00,$01,$02,$04,$08,$10,$00,$00 ; ASCII "\"
        db      $18,$10,$10,$10,$10,$10,$18,$00 ; ASCII "]"
        db      $04,$0a,$11,$00,$00,$00,$00,$00 ; ASCII "^"
        db      $00,$00,$00,$00,$00,$00,$1f,$00 ; ASCII "_"
        db      $04,$04,$04,$00,$00,$00,$00,$00 ; ASCII "`"
        db      $00,$00,$0c,$12,$12,$12,$1c,$00 ; ASCII "a"
        db      $02,$02,$0e,$12,$12,$12,$0e,$00 ; ASCII "b"
        db      $00,$00,$0c,$12,$02,$12,$0c,$00 ; ASCII "c"
        db      $10,$10,$1c,$12,$12,$12,$1c,$00 ; ASCII "d"
        db      $00,$00,$0c,$1e,$02,$12,$0c,$00 ; ASCII "e"
        db      $08,$14,$04,$0e,$04,$04,$04,$00 ; ASCII "f"
        db      $00,$0c,$12,$12,$1c,$12,$0c,$00 ; ASCII "g"
        db      $02,$02,$0e,$12,$12,$12,$12,$00 ; ASCII "h"
        db      $00,$00,$04,$00,$04,$04,$04,$00 ; ASCII "i"
        db      $00,$08,$00,$08,$08,$08,$06,$00 ; ASCII "j"
        db      $02,$02,$0a,$06,$06,$0a,$12,$00 ; ASCII "k"
        db      $04,$04,$04,$04,$04,$04,$04,$00 ; ASCII "l"
        db      $00,$00,$0b,$15,$15,$15,$15,$00 ; ASCII "m"
        db      $00,$00,$0e,$12,$12,$12,$12,$00 ; ASCII "n"
        db      $00,$00,$0c,$12,$12,$12,$0c,$00 ; ASCII "o"
        db      $00,$0e,$12,$12,$0e,$02,$02,$00 ; ASCII "p"
        db      $00,$1c,$12,$12,$1c,$10,$10,$00 ; ASCII "q"
        db      $00,$00,$0e,$12,$02,$02,$02,$00 ; ASCII "r"
        db      $00,$00,$1c,$02,$0c,$10,$0e,$00 ; ASCII "s"
        db      $00,$00,$04,$0e,$04,$04,$04,$00 ; ASCII "t"
        db      $00,$00,$12,$12,$12,$12,$1c,$00 ; ASCII "u"
        db      $00,$00,$12,$12,$12,$12,$0c,$00 ; ASCII "v"
        db      $00,$00,$15,$15,$15,$15,$0a,$00 ; ASCII "w"
        db      $00,$00,$11,$0a,$04,$0a,$11,$00 ; ASCII "x"
        db      $00,$14,$14,$14,$08,$04,$02,$00 ; ASCII "y"
        db      $00,$00,$1e,$08,$04,$02,$1e,$00 ; ASCII "z"
        db      $08,$04,$04,$02,$04,$04,$08,$00 ; ASCII "{"
        db      $04,$04,$04,$00,$04,$04,$04,$00 ; ASCII "|"
        db      $02,$04,$04,$08,$04,$04,$02,$00 ; ASCII "}"
        db      $00,$14,$0a,$00,$00,$00,$00,$00 ; ASCII "~"

wwvptb: db      1,0,0,0,0       ; 0-4: Position marker table.
        db      0,0,0,0,1       ; 5-9: 1 for when we expect a position marker,
        db      0,0,0,0,0       ; 10-14: 0 for when we expect data
        db      0,0,0,0,1       ; 15-19: So we can do rudimentary error checking
        db      0,0,0,0,0       ; 20-24
        db      0,0,0,0,1       ; 25-29
        db      0,0,0,0,0       ; 30-34
        db      0,0,0,0,1       ; 35-39
        db      0,0,0,0,0       ; 40-44
        db      0,0,0,0,1       ; 45-49
        db      0,0,0,0,0       ; 50-54
        db      0,0,0,0,1       ; 55-59


;       This is a table succesively setting 1 bits from the LSBit to MSBit
;       It is for creating the seconds bargraph.
bartbl: db      $00,$01,$03,$07,$0f,$1f,$3f,$7f

;       These are test sets for the WWVB decoding code (wwvpt1)
;       Idea is to test a lot of boundary conditions I can't wait for

$IF WWVDBG
wwvdb1: db      $03,$18,$85,$22,$84,$45,$02,$16 ; 23:33pm UTC 9/7/08 DST (my first live debugging)
;               Check the basic date math including boudary conditions
;               These can be simulated, PC=wwvdb,T,HX=label below,GO
;               *** TABLES BELOW ASSUMED 1/1/XX WAS DAY #0, SO ALL OFF BY 1 IF I NEED TO USE THEM AGAIN
wwvdb2: db      $03,$18,$86,$02,$A0,$A0,$02,$16 ; 23:33pm UTC 2/28/08 DST (checking leap year)
wwvdb3: db      $03,$18,$86,$02,$A4,$A0,$02,$16 ; 23:33pm UTC 2/29/08 DST (checking leap year)
wwvdb4: db      $03,$18,$86,$03,$00,$A0,$02,$16 ; 23:33pm UTC 3/1/08  DST (checking leap year)
wwvdb5: db      $03,$18,$86,$02,$A0,$A0,$01,$C6 ; 23:33pm UTC 2/28/07 DST (checking non leap year)
wwvdb6: db      $03,$18,$86,$02,$A4,$A0,$01,$C6 ; 23:33pm UTC 3/1/07  DST (checking non leap year)
wwvdb7: db      $03,$18,$86,$14,$A4,$A0,$02,$16 ; 23:33pm UTC 7/18/08 DST (day 199, LY)
wwvdb8: db      $03,$18,$86,$20,$00,$A0,$02,$16 ; 23:33pm UTC 7/19/08 DST (day 200, LY)
wwvdb9: db      $03,$18,$86,$14,$A4,$A0,$01,$C6 ; 23:33pm UTC 7/19/07 DST (day 199, NLY)
wwvdba: db      $03,$18,$86,$20,$00,$A0,$01,$C6 ; 23:33pm UTC 7/20/07 DST (day 200, NLY)
;               Check out DST transitions (already checked out DST/not)
;               Run these to see.  
wwvdbb: db      $05,$40,$0E,$04,$84,$A0,$02,$14 ; 7:59am UTC 4/1/08 ST-DST transition (1:59am MST)
wwvdbc: db      $05,$40,$12,$04,$84,$A0,$02,$14 ; 9:59am UTC 4/1/08 After ST-DST transition (4:59am MDT)
wwvdbd: db      $05,$40,$0C,$23,$90,$A0,$02,$12 ; 6:59am UTC 10/1/08 DST-ST transition (1:59am MDT)
wwvdbe: db      $05,$40,$10,$23,$90,$A0,$02,$12 ; 8:59am UTC 10/1/08 After DST-ST transition (2:59am MST)
;               Leap seconds tests
;               Also stress test of backing out time for local offset!
wwvdbf: db      $05,$40,$0A,$00,$00,$A0,$02,$40 ; 5:59am UTC 1/1/09 No Leap Second (11:59pm MST)
wwvdbg: db      $05,$40,$0A,$00,$00,$A0,$02,$48 ; 5:59am UTC 1/1/09 With Leap Second (11:59pm MST)

$ENDIF

; Message table.
; Format is dtx, dty, message.  If message is less than 5 chars, null terminate it.
m_wwvb: db      3,0,"WWVB",0
m_sync: db      3,8,"SYNC",0
m_rx1:  db      6,8,"RX1",0
m_set:  db      6,0,"SET",0
m_get:  db      6,0,"GET",0
m_wwl2: db      3,8,"WWVB",0
m_time: db      3,8,"TIME",0

m_tzon: db      0,0,"TZONE"
m_ast:  db      6,8,"AST",0     ; TZ index 0
m_est:  db      6,8,"EST",0     ; TZ index 1
m_cst:  db      6,8,"CST",0     ; TZ index 2
m_mst:  db      6,8,"MST",0     ; TZ index 3
m_pst:  db      6,8,"PST",0     ; TZ index 4
m_akst: db      3,8,"AKST",0    ; TZ index 5
m_hast: db      3,8,"HAST",0    ; TZ index 6
m_dst:  db      3,0,"DST?",0
m_yes:  db      6,8,"YES",0
m_no:   db      9,8,"NO",0

; Timezone lookup Tables
; First is time offset, second is text index
tztbl:  db      $fc,$fb,$fa,$f9,$f8,$f7,$f6
tttbl:  dw      m_ast,m_est,m_cst,m_mst,m_pst,m_akst,m_hast

