        page
******************************************************
** Copyright 2007 CMI Productions.                  **
** Lots of rights reserved.                         **
** Free for personal use as long as this copyright  **
** message is maintained in the source and the LCD  **
** copyright message is also preserved.  Commercial **
** use prohibited without CMIs written concent.     **
******************************************************


        org     apram        ; the place for our variables

* BASIC MEMORY MAP:
* 040-04f: Reserved for MON08
* 050-1bf: App RAM
* 1c0-23f: Reserved for MON08
*
* ***********WARNING WARNING WARNING WARNING WARNING WARNING **********
* ***********WARNING WARNING WARNING WARNING WARNING WARNING **********
*
* The first 64 bytes of RAM are very special, they get used twice.
* The variables commented with ;* are 64 bytes of RAM that are re-used
* by the sensor sensor calibration routines where I temporarily need
* a workspace that big to hold IDs.
*
* Note also that I try to make the distinction between RAM that is in
* the range $40-$ff and then the rest from $100 on.  The P&E assembler
* does not know how to check for this automatically, so this needs to
* be a manual check.  I do this by issuing an 8-bit address only
* instruction to the variable ramff.  If I go over $00ff, then the
* compiler will generate an error message.
*
* **************  AS SUCH, ALL THESE VARAIBLES WILL GET  **************
* ************** TRASHED DURING THE CALIBRATION ROUTINE. **************
*
* Don't mess with the special area below unless you really have to.
* If you must, make sure that you maintain a block of at least 64 bytes that
* arn't needed during the calibration routine and also don't need to keep
* their value after the calibration routine starts.
*
* The full contents of this memory is used multiple times during the
* sensor calibration process to store temporary data while flash is
* erased and re-written.
*

;***************** START OF SUPER-SPECIAL 64-BYTE AREA ********************

dspmtx: rmb     64              ; The Inner LED matrix buffer

;****************** END OF SUPER-SPECIAL 64-BYTE AREA *********************

; THESE TWO BUFFERS MUST NOT BE SEPARATED, I COUNT ON THEM BEING SEQUENTIAL!
clkmtx: rmb     16              ; radial clock LED matrix, Phase A
clkmty: rmb     16              ; radial clock LED matrix, Phase B

; LED Refresh variables
phase:  rmb     1               ; outer ring phase
drow:   rmb     1               ; row number
blink:  rmb     1               ; blink flags
                                ; bit 0=minutes, 1=hours, 2=days, 3=month
                                ; 4-7 reserved
; The official time!
rtchld: rmb     1               ; RTC hold flag (non-0=hold)
dsphld: rmb     1               ; time display hold
ruftim: rmb     1               ; rough time counter (1ms, counts to 100)
ssecs:  rmb     1               ; The Time: 1/10ths of a second
secs:   rmb     1               ; The Time: seconds
mins:   rmb     1               ; The Time: minutes
hrs:    rmb     1               ; The Time: hours
day:    rmb     1               ; The Time: day of month
month:  rmb     1               ; The Time: month
year:   rmb     1               ; The Time: year
newtim: rmb     1               ; new time flag (for LED Matrix)

curkey: rmb     1               ; The debounced key value
keycnt: rmb     1               ; counts how long an up/down key has been pressed
cntr:   rmb     1               ; field pointer for time setting
temp:   rmb     1               ; temp value

pmins:  rmb     1               ; previous minutes (for sync stuff)

ssmode: rmb     1               ; sub-second display mode

dtx:    rmb     1               ; x offset in pixels for writing characters
dty:    rmb     1               ; y offset in pixels for writing characters
xyoff:  rmb     2               ; x & Y offset in bytes for writing characters
xshif:  rmb     1               ; X byte shift value for writing chracters
cshif:  rmb     1               ; shift counter
rshif:  rmb     1               ; row counter
ctoff:  rmb     2               ; Character table offset for reading
putsbf: rmb     5               ; puts buffer (text to write)
putspt: rmb     1               ; puts pointer

atemp:  rmb     2               ; buffer for ASCII data conversions

wwvbst: rmb     1               ; WWVB state machine
wwvbt:  rmb     8               ; WWVB Timecode bits (minus markers)
wwvbpt: rmb     1               ; place marker in WWVB reception
wwvstm: rmb     1               ; Symbol time counter

wwmins: rmb     1               ; WWV Time: minutes
wwhrs:  rmb     1               ; WWV Time: hours
wwday:  rmb     1               ; WWV Time: day of month
wwmonth:rmb     1               ; WWV Time: month
wwyear: rmb     1               ; WWV Time: year
wwvdsf: rmb     1               ; DST transition flag (0=nuthin,1=to ST, 2=to DST)
wwvlsf: rmb     1               ; Leap Second flag
nsecs:  rmb     1               ; number of seconds in the current minute
wwvled: rmb     1               ; WWV LED value

ramff:  rmb     1               ; this is the check byte for the base page
