        page
******************************************************
** Copyright 2007 CMI Productions.                  **
** Lots of rights reserved.                         **
** Free for personal use as long as this copyright  **
** message is maintained in the source and the LCD  **
** copyright message is also preserved.  Commercial **
** use prohibited without CMIs written concent.     **
******************************************************
; -----------------------------------------------------------------------------
; File:         util.asm
; Function:     General purpose utilities
; Routines:     b2as2: Converts byte to ASCII 00-99
;               cnvbcd: Converts 2 BCD digits to binary
;               wfnkey: Waits for "next" key (no key, then new key)
;               wnokey: Waits for no key being pressed
; -----------------------------------------------------------------------------
        page
; -----------------------------------------------------------------------------
; Routine:      b2as2
; Called By:
; Calls:        None
; Gazintas:     None
; Gazoutas:     atemp (2-byte ASCII result)
; Function:     This routine converts ab 8-bit binary number to ASCII.  It can
;               only handle numbers up to 99.  We convert by successively
;               subtracting 10's until the result is less than 10, then finally
;               do the units.
; -----------------------------------------------------------------------------
b2as2:  mov     #'0',atemp      ; prefill 10's with ASCII '0'

b2a10:  cmp     #10             ; see if >10
        blo     b2a1            ; if not, on to 1's
        sub     #10             ; subtract 10 from temperature
        inc     atemp           ; increment ASCII 10's digit
        bra     b2a10           ; see if anther 10

b2a1:   add     #'0'            ; convert units to ASCII
        sta     atemp+1         ; store it, done!

b2aex:  rts                     ; all done

        page
; -----------------------------------------------------------------------------
; Routine:      cnvbcd
; Called By:    wwvpt
; Calls:        None
; Gazintas:     A=2-digit BCD value
; Gazoutas:     A=Binary value
; Globals:      None
; Function:     This routine converts a two-digit BCD value into a pure binary
;               value.  Input format is 10's value is in the four MSBs of A
;               and 1's value is in the LSBs.  All this routine does is take
;               the 10's value, multiply it by 10 and add to the 1's bits.
; -----------------------------------------------------------------------------
cnvbcd: psha                    ; save value for a bit
        nsa                     ; get 10's in LSBits
        and     #$0f            ; LSBs only
        ldx     #10             ; 10...
        mul                     ; done, A has result, answer<100, so X=0
        sta     atemp           ; save that
        pula                    ; get original value back
        and     #$0f            ; get 1's
        add     atemp           ; add in 10's
        rts                     ; all done

        page
; -----------------------------------------------------------------------------
; Routine:      wfnkey
; Called By:    lotsa places
; Calls:        None
; Gazintas:     None
; Gazoutas:     None
; Function:     This routine waits for no key to be pressed, then waits for
;               one to be pressed.  Pretty cheasy, but is needed in enough
;               places that a routine made sense.
; -----------------------------------------------------------------------------
wfnkey: lda     curkey          ; see if key
        bne     wfnkey          ; wait until no key pressed
wwwkey: lda     curkey          ; look again
        beq     wwwkey          ; wait until a key pressed
        rts

        page
; -----------------------------------------------------------------------------
; Routine:      wnokey
; Called By:    lotsa places
; Calls:        None
; Gazintas:     None
; Gazoutas:     None
; Function:     This routine waits for no key to be pressed, then returns.
; -----------------------------------------------------------------------------
wnokey: lda     curkey          ; see if key
        bne     wnokey          ; wait until no key pressed
        rts                     ; done

