        page
******************************************************
** Copyright 2006 CMI Productions.                  **
** Lots of rights reserved.                         **
** Free for personal use as long as this copyright  **
** message is maintained in the source and the LCD  **
** copyright message is also preserved.  Commercial **
** use prohibited without CMIs written concent.     **
******************************************************
********************************************************************************
*
*       Mymon: Sortof based on FPFUM.ASM example from the Motorola
*       Application note #1770 explaining how to program your own flash
*       without the use of the debugger. Biggest changes are:
*       1) Changed code to work with P&E Assembler
*       2) Most of monitor in ROM, not everything in RAM
*       3) Major emphasis on minimum RAM usage.
*       4) ASCII-based file xfer protocol.
*       5) Ability to be called by an App for permanent variable storage.
*       6) Changed for the GP32.
*
*       With all the above changes, the similarity to AN#1770 is about zero,
*       but I'll still give it credit for getting me started.
*
*       If I followed my guidelines correctly, all labels in this code begin
*       with mn, so as long as you avoid any labels in the application code
*       that start that way, the two routines should be able to co-exist
*       peacefully.  The only lables that don't start with mn are the ones
*       intended to be reference by the applicaiton.
*
********************************************************************************
* REVISION HISTORY:
* 1.00.0 - ??-??-?? First release.  Works fine.
* 1.00.1 - 12-18-99 Added Debug splash screen for user-friendliness.
* 1.01.0 - 02-05-00 Changed over to GP32 support, abandoned GP20.
*          Functional difference is that minimum data area that can be
*          erased is now 128 bytes instead of 64.  Otherwise the same
*          functionality over the GP20 is preserved.
*          Also, memory map totally changes, monitor is now at the top of Flash.
********************************************************************************
*
*       Here is the idea of this monitor:
*       1) This monitor comes up first at boot and takes over.  The very
*          initial code is application-specific only enough to initialize
*          enough to see if the user presses the magic sequence to get
*          into the semi-secret monitor mode.  If the download sequence
*          is met, the UART is initialized and we go get some new
*          application code from the PC, program it, and issue a reset.
*       2) If the semi-secret sequence is not pressed, control is passed to the
*          application program just as if it had recovered from a normal reset.
*       3) A call is provided so that the application program can request that
*          a block of Flash can be programmed.  Note that doing so trashes all
*          of RAM, so after the sequence is programmed, the application should
*          reset itself.
*       4) This code should be included along with the application so it can
*          be included with the application code so all the monitors can find
*          the correct vectors for getting past the monitor ROM super-secret
*          initialization sequence.  the PC app will be smart enough to only
*          load the application, not reload the monitor too.
*
********************************************************************************
*
*       MEMORY MAP (REGIONS):
*       0040-004f:   16 Reserved for the monitor data
*       0050-01bf:  368 Application RAM
*       01c0-023f:  128 Reserved for the monitor ram-resident code
*       8000-EFFF:  28K User Code area
*       F000-F7FF:   2K Reserved for this monitor program
*       F800-FDFF: 1.5K User Data area
*       FFDC-FFFF:   24 Exception vectors under monitor control
*
********************************************************************************
        page
********************************************************************************
*
*       MEMORY MAP (SPECIFIC ADDRESSES):
*       F000: Vector for Monitor to startup (reset)
*       F003: Vector for Monitor to erase user-flash variable area
*       F006: Vector for Monitor to program user-flash variable area
*       8000: Vector for Application timebase vector
*       8004: Vector for Application A/D conversion Complete
*       8008: Vector for Application Keyboard
*       800c: Vector for Application SCI Tx
*       8010: Vector for Application SCI Rx
*       8014: Vector for Application SCI Error
*       8018: Vector for Application SPI Tx
*       801c: Vector for Application SPI Rx
*       8020: Vector for Application Timer 2 overflow
*       8024: Vector for Application Timer 2 channel 1
*       8028: Vector for Application Timer 2 channel 0
*       802c: Vector for Application Timer 1 overflow
*       8030: Vector for Application Timer 1 channel 1
*       8034: Vector for Application Timer 1 channel 0
*       8038: Vector for Application PLL
*       803c: Vector for Application external IRQ
*       8040: Vector for Application SWI instruction
*       8044: Vector for Application power-on-reset
*
********************************************************************************
*
*       The first sequence of executable statements in the application should
*       be something like the following:
*
*       $base 10T
*       $Include 'gp20regs.inc' (my slightly modified one!)
*       $Include 'mymon.asm'
*
*       Application ram starts at apram (currently $0050) and ends at aprend
*       (currently $01bf).  Application ROM starts at aprom ($8000) and ends
*       at $EFFF).
*
*       Note that apram, aprend, and aprom are defined here rather than in
*       gp20regs.inc, since this is the place that really defined their
*       location.
*
********************************************************************************
        page
********************************************************************************
*
*       The protocol between the monitor and PC goes as follows:
*       1) Monitor sends "SVx.xx.x<cr>" (current version)
*       2) Monitor waits for up to 1 second. If no responce, back to 1)
*       3) PC sees Monitor message and sends "SH<cr>"
*       4) Monitor loads RAM-resident code
*       5) Monitor erases flash from 8000-EFFF
*       6) If erase fails, monitor sends "SF<cr>" and it and PC quit.
*       7) Monitor sends "SAxxxx<cr>".  xxxx is start address for 8-byte block
*          Address in ASCII hex, starts at 8000, 8008, 8010, etc.
*       8) PC sends "SDxx..xxM<cr>" or "SDxx..xxX<cr>
*          xx..xx is EXACTLY 8 bytes of ASCII hex data.
*          M means more data to follow, X means this is last record
*       9) Monitor programs data to flash.
*       10) If program success and more data, back to step 5
*       11) If program failure, monitor sends SF, PC aborts
*       12) If last record and success, Monitor sends "SF<cr>", PC quits
*       13) Monitor quits by doing a sorta reset and starts the app.
*
********************************************************************************
*
*       The application has two routines available to it in the monitor, one to
*       erase a sector (128 bytes) of flash and the second to program a sub-
*       sector (8 bytes) of flash.  The erase routine can only erase exactly
*       128 bytes, and the program routine only programs exactly 8 bytes.  If
*       your application needs to deal with different sized data, you will
*       need to handle that on the application side.  I'm trying to keep this
*       monitor (and the RAM it consumes) as small as possible.  Addresses
*       provided are assumed to be the first byte in the 64 or 8 byte area to
*       be erased or programmed, no error checking is performed.
*
*       The two routines (and data needed) are:
*       ERASE SECTOR:
*         LDHX address of a 128-byte sector to erase
*         jsr appera (should be fixed at $f003)
*         C set means erase successful
*         C clear means erase failure
*
*       PROGRAM SUB-SECTOR:
*         Store 8 bytes of data in (mndray)
*         LDHX 16-bit address of an 8-byte sector to program
*         jsr apppgm (should be fixed at $f006)
*         C set means erase successful
*         C clear means erase failure
*
*       NOTE:  If the application uses interrupts, they must be disabled!
*       As a pecautionary measure, the monitor will unilaterally turn
*       off interrupts in case you forget.
*
*       While running either of these routines, the monitor makes use of the
*       two areas dedicated to it in the $0040-$004f and $01A0-$023f range
*       to perform the above functions.  Any application data stored in these
*       locations will be trashed.  The monitor does NOT assume any data in
*       these areas is maintained between calls, so the application can make
*       use of these areas between monitor calls without affecting monitor
*       operation.  Also, if the application does not intend to use the above
*       two routines, then all RAM is available to the application.
*
********************************************************************************
        page
********************************************************************************
* Include stuff.  Only needed when debugging the monitor by itself.
********************************************************************************
* $BASE 10T
* $Include 'gp20regs.inc'
* $SET DEBUG

********************************************************************************
* APPLICATION-SPECIFIC MEMORY AND I/O EQUATES
********************************************************************************
apram:  equ     $50             ; start of applictaion RAM
aprend: equ     $1bf            ; end of application RAM
aprom:  equ     urom32          ; the place for application ROM to begin
mnrom:  equ     $f000           ; the place for monitor ROM to begin
apvars: equ     $f800           ; the place for Flash variables
mnrapp: equ     aprend+1        ; the place to copy ram apps to
mnmxpg: equ     64              ; max number of tries to program a page

*       Define the vector locations for the applications interrupt
*       vectors.

uvtbas: equ     $8000           ; Vector for timebase vector
uvadc:  equ     $8004           ; Vector for A/D conversion Complete
uvkey:  equ     $8008           ; Vector for Keyboard
uvsctx: equ     $800c           ; Vector for SCI Tx
uvscrx: equ     $8010           ; Vector for SCI Rx
uvscer: equ     $8014           ; Vector for SCI Error
uvsptx: equ     $8018           ; Vector for SPI Tx
uvsprx: equ     $801c           ; Vector for SPI Rx
uvt2ov: equ     $8020           ; Vector for Timer 2 overflow
uvt2c1: equ     $8024           ; Vector for Timer 2 channel 1
uvt2c0: equ     $8028           ; Vector for Timer 2 channel 0
uvt1ov: equ     $802c           ; Vector for Timer 1 overflow
uvt1c1: equ     $8030           ; Vector for Timer 1 channel 1
uvt1c0: equ     $8034           ; Vector for Timer 1 channel 0
uvpll:  equ     $8038           ; Vector for PLL
uvirq:  equ     $803c           ; Vector for external IRQ
uvswi:  equ     $8040           ; Vector for SWI instruction
uvrst:  equ     $8044           ; Vector for power-on-reset

        page
;* <A NAME="vars">
                ORG     ram
mndray:         RMB     8               ; RESERVE 8 BYTES FOR DATA
mnstad:         RMB     2               ; FIRST ADDR TO BE PROGRAMMED
mntmph:         RMB     1               ; RAM COUNTER (HI BYTE)
mntmpl:         RMB     1               ; RAM COUNTER (LOW BYTE)
mntmp2:         RMB     1               ; TEMP. HOLDING LOC. FOR TRANSFERS/PROG TRIES
mntmp3:         RMB     1               ; yet another temporary value
mnbyct:         RMB     1               ; BYTE COUNT USED DURING PAGE PROG.
mncbyt:         RMB     1               ; CURRENT BYTE BEING READ/WRITTEN (0-7)

********************************************************************************

        org     ivtbas          ; the place to start for interrupt vectors
        fdb	$8000           ; Vector for timebase vector
        fdb	$8004           ; Vector for A/D conversion Complete
        fdb	$8008           ; Vector for Keyboard
        fdb	$800c           ; Vector for SCI Tx
        fdb	$8010           ; Vector for SCI Rx
        fdb	$8014           ; Vector for SCI Error
        fdb	$8018           ; Vector for SPI Tx
        fdb	$801c           ; Vector for SPI Rx
        fdb	$8020           ; Vector for Timer 2 overflow
        fdb	$8024           ; Vector for Timer 2 channel 1
        fdb	$8028           ; Vector for Timer 2 channel 0
        fdb	$802c           ; Vector for Timer 1 overflow
        fdb	$8030           ; Vector for Timer 1 channel 1
        fdb	$8034           ; Vector for Timer 1 channel 0
        fdb	$8038           ; Vector for PLL
        fdb	$803c           ; Vector for external IRQ
        fdb	$8040           ; Vector for SWI instruction
$IF DEBUG
        ;fdb    $ffff           ; $ffff/$0000 at power-on-reset to support debug
$ELSEIF
        fdb	mnstrt          ; Vector for power-on-reset for normal operation
$ENDIF
        page
********************************************************************************
*       This is the main debug routine that gets executed after reset.  IT is
*       pretty simple.  We first go intialize the hardware.  If the semi=secret
*       button-pushes are not being pressed, this code jumps direcltly to the
*       application.  If the semi-secret code is being pressed, we go do the
*       initial negotiations (mnnego), erase the application (mnerap),
*       download/program the new application (mngdat), and if all that works,
*       go execute the users new code.
********************************************************************************
;* <A NAME="main">
        org     mnrom            ; just start at the beginning of Flash

mnstrt: jmp     mnstr2          ; vector to the monitor startup
appera: jmp     mndter          ; vector to the application data erase routine
apppgm: jmp     mndtpg          ; vector to the application data program routine

mnstr2: jsr     mnhwin          ; go do the target-specific hardware setup
        jsr     mnnego          ; do the pre-RAM negotiation stuff
        jsr     mnerap          ; erase the application code (locks if failure)
        jsr     mngdat          ; go get the program data
mnxx:   bra     mnwinx          ; all done, do a user-reset


*****************************************************************
*       This is (hopefully) the only target-specific code.
*       This code is in charge of the minimal hardware setup
*       needed to see if the user wants to enter monitor mode
*       on power up using some kind of target-specific input.
*       For example, this could be pressing several keys
*       simultaneously.  If monitor mode is not selected, this
*       code should just jump to $c044 and let the application
*       do its thing, preferably NOT relying on whatever
*       initialization code was done here.
*       If monitor mode is selected, this code should also
*       initialize the UART to 9600 baud and return
*****************************************************************
;* <A NAME="hw init">
mnhwin: clr     porta           ; Port A all lows
        mov     #$07,ddra       ; Bits 3:1 outputs, rest inputs
        clr     portb           ; start out all low
        mov     #$80,ddrb       ; switch inputs, sel output, unused outputs
        mov     #$06,portc      ; Bit 0 will be open drain, bits 1,2 drive high
        clr     ddrc            ; don't drive nuthin--yet
        clr     portd           ; drive 0's where applicable
        mov     #$df,ddrd       ; default pins to outputs except WWVB input
        bset    0,config1       ; turn off COP for now

        lda     portb           ; get the port B data
        and     #$78            ; look only at the switches
        cmp     #$60            ; See if menu & select, but not up/down
        bne     mnwinx          ; If not, go to user code

* Now that we know we are doing to do the monitor thing, set up the UART

        lda     #$40            ; SCI on, 8 bits, no parity, no weird stuff
        sta     scc1            ; make it so
        lda     #$0c            ; Rx,Tx on, no IRQs, no breaks
        sta     scc2            ; make it so
        lda     #$00            ; No 9th bit, DMA, or noise processing.
        sta     scc3            ; make it so
$IF DEBUG
        lda     #$04            ; 9600 baud assuming 2.???MHz bus clock
$ELSEIF
        lda     #$32            ; 9600 baud assuming 8MHz bus clock
$ENDIF
        sta     scbr            ; make it so

        jsr     mnshi           ; go say hi
        rts                     ; all done

mnwinx: rsp                     ; reset SP so we look like a real reset
        jmp     uvrst           ; jump to application reset vector


        page
*******************************************************************************
*       Routine mnnego
*       This is the routine that takes care of all of the pre flash
*       programming negotiations.  These are steps 1-3 in the protocol
*       description described in the headers.
*******************************************************************************
;* <A NAME="negotiation">
mnnego: ldhx    #mnhmsg         ; point to the hello message
        jsr     mnsmsg          ; send it to the PC
        jsr     mngbyt          ; get response (or timeout)
        bcc     mnnego          ; if no response, try again
        cmp     #'S'            ; Should be an S
        bne     mnnegr          ; if not, wait a bit before trying again

        jsr     mngbyt          ; get response (or timeout)
        bcc     mnnego          ; if no response, try again
        cmp     #'H'            ; Should be an H
        bne     mnnegr          ; if not, wait a bit before trying again

        jsr     mngbyt          ; get response (or timeout)
        bcc     mnnego          ; if no response, try again
        cmp     #13             ; Should be a carraige return
        bne     mnnegr          ; if not, wait a bit before trying again

        rts                     ; if all that worked, return

mnnegr: jsr     mngbyt          ; see if another byte
        bcc     mnnego          ; if not, go try hello message again
        bra     mnnegr          ; if something showed up, trash it

mnhmsg: db      'SV1.01.0'
        db      13,0
        page
*******************************************************************************
*       This is the monitor routine that gets a record of program data from
*       the host PC and writes it to flash.  This does the whole job.  This
*       routine differs from the sample Motorola code in one significant way,
*       this code runs mostly out of Flash (the monitor is permanent), then
*       just leaps to RAM code for the final erase/programming stage.
*******************************************************************************
;* <A NAME="get ASCII data">
mngdat: mov     #$80,mnstad     ; App code start address MSB
        clr     mnstad+1        ; App code start address LSB

mnglp:  lda     #'S'            ; An S
        jsr     mnsbyt          ; send it
        lda     #'A'            ; An A
        jsr     mnsbyt          ; send it
        lda     mnstad          ; Address MSB
        jsr     mnshex          ; send it in ASCII hex
        lda     mnstad+1        ; Address LSB
        jsr     mnshex          ; send it in ASCII hex
        lda     #13             ; A carraige return
        jsr     mnsbyt          ; send it

        jsr     mngbyt          ; get response (or timeout)
        cmp     #'S'            ; Should be an S
        bne     mngerr          ; if not, very bad

        jsr     mngbyt          ; get response (or timeout)
        cmp     #'D'            ; Should be an D
        bne     mngerr          ; if not, very bad

        clr     mnbyct          ; clear byte counter

mngdlp: jsr     mnghex          ; go get an ASCII hex byte
        bcc     mngerr          ; if error, do die quickly
        ldx     mnbyct          ; get the buffer offset
        clrh                    ; make sure H is 0
        sta     mndray,x        ; save the data
        inc     mnbyct          ; increment pointer
        lda     mnbyct          ; get it back
        cmp     #8              ; see if 8 bytes
        bne     mngdlp          ; if not, loop

        jsr     mngbyt          ; get response
        sta     mnbyct          ; save it for later

        jsr     mngbyt          ; get response
        cmp     #13             ; Should be a <CR>
        bne     mngerr          ; if not, very bad

        jsr     mnrpgm          ; go program 8 bytes
        bcc     mngdpr          ; if programming failure, say so

        lda     mnstad+1        ; get base address LSB
        add     #8              ; increment by 8 bytes
        sta     mnstad+1        ; and save it
        lda     mnstad          ; get MSB
        adc     #0              ; add carry if any
        sta     mnstad          ; store back

        lda     mnbyct          ; get more/done flag
        cmp     #'M'            ; see of more
        beq     mnglp           ; if so, go get another record
        cmp     #'X'            ; see if PC says all done
        bne     mngerr          ; if neither, we got a serious error
        rts                     ; otherwise done with download

mngdpr: ldhx    #mnpemg         ; point to the hello message
        jsr     mnsmsg          ; send it to the PC
mngerr: bra     mngerr          ; something went bad, die here

mnpemg: db      'SF'
        db      13,0
        page
*******************************************************************************
*       This are the routines that send data to the UART.
*       mnsmsg: sends a null-terminated message
*       mnsbyt: sends byte in A
*       mnshex: sends A as ASCII hex
*******************************************************************************
;* <A NAME="I/O routines">
mnsmsg: lda     ,x              ; get a byte of data
        beq     mnsex           ; if 0, all done

        sta     scdr            ; send it on it's way
mnmwlp: brclr   6,scs1,mnmwlp   ; wait for Tx buffer to empty

        aix     #1              ; increment byte pointer
        bra     mnsmsg          ; do bytes until a null character

mnsex:  rts                     ; all done sending message

*******************************************************************************
mnsbyt: sta     scdr            ; send it on it's way
mnmwl2: brclr   6,scs1,mnmwl2   ; wait for Tx buffer to empty
        rts                     ; all done

*******************************************************************************
mnshex: psha                    ; save A
        nsa                     ; get MSN in LSN
        and     #$0f            ; LSN only
        tax                     ; make an index
        clrh                    ; make sure index is right
        lda     mnhtb,x         ; convert to ASCII hex
        bsr     mnsbyt          ; send it

        pula                    ; get original data back
        and     #$0f            ; LSN only
        tax                     ; make an index
        lda     mnhtb,x         ; convert to ASCII hex
        bsr     mnsbyt          ; send it
        rts                     ; all done

mnhtb:  db      "0123456789abcdef"
*******************************************************************************
*       This is the routine that gets a character from the UART.  If no
*       character shows up for about a second, this routine times out with
*       the C bit clear, otherwise A has the register and C is set.
*       The basic loop is 15 clocks times 65536 comes out to .12 seconds at
*       8MHz.  This means 8 of those loops at 8MHz, and I'll simplify to one
*       loop in debug mode for 2 seconds.
*       C clear means error
*       C set means OK
*******************************************************************************
mngbyt: clr	mntmpl          ; Counter LSB
        clr	mntmph          ; Counter MSB
        clr     mntmp2          ; Big counter

mngb1:  lda     scs1            ; (3) get the SCI status
        and     #$20            ; (2) get data ready bit
        bne     mngb3           ; (3) if data, wait all over gain
        inc     mntmpl          ; (4) increment counter LSB
        bne     mngb1           ; (3) if no carry, all done
        inc     mntmph          ;     if LSB carry inc MSM
        bne     mngb1           ;     if no MSB carry, loop some more
$IF DEBUG
$ELSEIF
        inc     mntmp2          ; superloop counter--not in debug mode
        lda     mntmp2          ; get count value
        cmp     #8              ; see if 8 loops
        bne     mngb1           ; if not, go around again
$ENDIF
        clra                    ; return 00 for timeout
        clc                     ; clear C for timeout flag
        rts                     ; all done

mngb3:  lda     scdr            ; dummy read of the data in case
        sec                     ; set C for no timeout flag
        rts                     ; all done

*******************************************************************************
*       This routine gets a ASCII-encoded hexadecimal byte from the UART
*       C is set for good data, clear if invalid data or timeout.
*       THIS ROUTINE ASSUMES THE ASCII HEX DATA IS LOWER-CASE FOR LETTERS!
*       C clear means error
*       C set means OK
*******************************************************************************
mnghex: jsr     mngbyt          ; go get a character from the UART
        bcc     mnghx           ; if timeout, error
        jsr     mnghcv          ; convert ASCII to binary
        bcc     mnghx           ; if invalid data, error
        nsa                     ; put in MSN
        sta	mncbyt          ; save for a bit

	jsr     mngbyt          ; go get another character from the UART
        bcc     mnghx           ; if timeout, error
        jsr     mnghcv          ; convert ASCII to binary
        bcc     mnghx           ; if invalid data, error
        add     mncbyt          ; add MSN

        sec                     ; return with carry set (good data)
mnghx:  rts                     ; all done (one way or 'tuther)

mnghcv: clrh                    ; 8-bit offset
        ldx     #15             ; end of ASCII-binary table
mnghcl: cmp     mnhtb,x         ; see if a match
        beq     mnghcx          ; if so, all done
        decx                    ; otherwise decrement x
        bpl     mnghcl          ; and if still 0-15, try again
        clc                     ; if no match, set error flag
        rts                     ; all done

mnghcx: txa                     ; get answer in A
        sec                     ; say good data
        rts                     ; all done

        page
*******************************************************************************
*       This is the ROM-routine for erasing the application.  All we do here
*       is copy the code that does the work to RAM and go execute it.  Once
*       complete, the RAM code returns with error bits set and we just pass
*       them back to the caller.
*******************************************************************************
;* <A NAME="Erase App (ROM)">
mnerap: jsr     mncpec          ; go copy the erase code to ram
        clra                    ; 0 in A means erase App area
        jsr     mnrapp          ; go execute the erase code
        bcc     mneraz          ; Carry clear means error
        rts                     ; if no error, return

mneraz: jmp     mngdpr          ; the place to die permanently


mncpec: ldhx    #mnrapp         ; the place to start copying to in RAM
        sthx    mntmph          ; remember this for a bit
        ldhx    #mnerrb         ; the starting place in Flash to copy from

mneral: mov     x+,mntmp2       ; get a source byte
        pshh                    ; save source MSB
        pshx                    ; save source LSB
        ldhx    mntmph          ; get destination address
        mov     mntmp2,x+       ; save byte
        sthx    mntmph          ; save address
        pulx                    ; get src address LSB back
        pulh                    ; get src address MSB back
        cphx    #mnerre         ; see if done
        bne     mneral          ; if not, next byte
        rts                     ; done copying

*******************************************************************************
*       This is the routine that takes the 8 bytes of data from the host PC
*       to program and gives it to the RAM routine to do the programming.
*       This code assumes that the flash has already been erased.
*       It only programs exactly 8 bytes.
*       Carry clear=Error
*       Carry set=OK
*******************************************************************************
;* <A NAME="Program App (ROM)">

mnrpgm: ldhx    #mnrapp         ; the place to start copying to in RAM
        sthx    mntmph          ; remember this for a bit
        ldhx    #mnpgrb         ; the starting place in Flash to copy from

mnpgal: mov     x+,mntmp2       ; get a source byte
        pshh                    ; save source MSB
        pshx                    ; save source LSB
        ldhx    mntmph          ; get destination address
        mov     mntmp2,x+       ; save byte
        sthx    mntmph          ; save address
        pulx                    ; get src address LSB back
        pulh                    ; get src address MSB back
        cphx    #mnpgre         ; see if done
        bne     mnpgal          ; if not, next byte

        jsr     mnrapp          ; go do it.
        rts                     ; return with error code

        page
*******************************************************************************
*       This is the application-callable routine to erase a sector of data.
*       This routine is SUPPOSED to be only used in the address range B800
*       through Bfff, but no checking is done to ensure this.  The address
*       passed in mnstad is an address in the 64-byte sector to be erased.
*       We just copy the erase code to RAM, make sure interrupts are off,
*       and go do the erasing.
*******************************************************************************
;* <A NAME="Erase Data (ROM)">
mndter: sthx    mnstad          ; store it
        jsr     mncpec          ; go copy the erase applet to RAM
        lda     #1              ; non-zero in A means erase data area
        sei                     ; make sure interrupts are off.
        jsr     mnrapp          ; go execute the erase code
        rts                     ; return with error code

*******************************************************************************
*       This is the program data area routine.  As currently defined, this
*       is 100% identical to the program application-area routine.  Only
*       difference is that we wanna make sure interrupts are off.
*******************************************************************************
;* <A NAME="Program Data (ROM)">
mndtpg: sei                     ; make sure interrupts are off.
        sthx    mnstad          ; store it
        jmp     mnrpgm          ; same as program App routine, leave hooks
        page
*************************************************************
*************************************************************
* START OF PROGRAMS THAT RUN FROM RAM.  ITS IN ROM, BUT
* GETS COPIED TO RAM TO GET EXECUTED.  IT MUST BE RELOCATABLE
* CODE!!
*************************************************************

*******************************************************************************
mnerrb: ; COPY-TO-RAM starting address for erase routine
*******************************************************************************
*       This is the routine that erases the application area.  This erases
*       the address range $8000 to $efff.  Alas I can't use the single
*       command that does $8000 to $FFFF as I want to protect my monitor
*       exception vectors.  Instead I perform 31 128-byte erase cycles
*       covering 8000-807f, 8080-80ff...8100-..efff.  Kind of a pain, but
*       that is the way it goes.  In order to save some time (and reduce
*       erase cycles to Flash), I check each 512-byte array to make sure it
*       needs erasing first.
*
*       This is also the routine to erase a 64-byte sector of flash for
*       application variables.  Since these two routines combined add up to
*       less than the program routine, this is not wasteful.  In the case
*       of erasing a data area, the address of the sector is in (mnstad).
*
*       On entry: A=0 means erase app area
*                 a=1 means erase data area
*
*******************************************************************************
;* <A NAME="Erase App (RAM)">
mneras: tsta                    ; see what erasure type
        bne     mne128          ; !0 means erase 128 bytes of data at mnstad

        mov     #$80,mnstad     ; Start Erase Address MSB
        clr     mnstad+1        ; Start Erase Address LSB

mnerab: bsr     mne128          ; go erase 128 bytes starting at (mnstad)
        bcc     mnerax          ; if error, abort

        mov     #$80,mnstad+1   ; increment LSB by 128 bytes
        bsr     mne128          ; erase the next sector
        bcc     mnerax          ; if error, abort
        clr     mnstad+1        ; reset LSB back to 0

        inc     mnstad          ; increment MSB (+256 bytes)
        lda     mnstad          ; get result
        cmp     #$f0            ; see if done ($f000)
        bne     mnerab          ; if not, go do next 128 bytes
        sec                     ; success flag

mnerax: rts                     ; return with error flag set

*******************************************************************************
*       This is the routine to erase a 128-byte page of Flash.  The starting
*       address is in (mnstad).  I first check the address range to make sure
*       it needs erasing at all before begining the procedure.
*       This routine assumes that mnstad is EXACTLY at a 128-byte boundry.
*       The numbers in parenthesis are the step numbers in section 11.5 of
*       the 6808 manual.
*******************************************************************************
mne128: bsr     mne1ce          ; see if erased
        bcs     mne12x          ; if so, no work needed

        lda     #$02            ; (1) set Erase bit
        sta     flcr            ;     set it

        lda     flbpr           ; (2) read the block protect register (dunnu why)

        ldhx    mnstad          ; (3) the block start address
        sta     ,x              ;     write to first address of target block

        lda     #10             ; (4) 10us delay
        bsr     mndlyu          ;     us delay routine

        lda     #$0a            ; (5) set the HVEN bit (ERASE still set)
        sta     flcr            ;     set it

        lda     #1              ; (6) 1ms delay
        bsr     mndlym          ;     ms delay routine

        lda     #$08            ; (7) clear the ERASE bit (HVEN still set)
        sta     flcr            ;     set it

        lda     #5              ; (8) 5us delay
        bsr     mndlyu          ;     us delay routine

        lda     #$00            ; (9) clear the HVEN bit
        sta     flcr            ;     set it

        lda     #1              ; (10) 1us delay
        bsr     mndlyu          ;      us delay routine

        bsr     mne1ce          ; should be erased now
mne12x: rts                     ; return with pass/fail set

*******************************************************************************
*       This checks to see if a 128-byte block is erased (all 1's)
*       C=1 means erased, C=0 means unerased.
*******************************************************************************
mne1ce: ldhx    mnstad          ; get the starting address
mnec1l: lda     ,x              ; get a byte
        coma                    ; invert it
        bne     mnec1x          ; if not $ff, block needs erasing
        aix     #1              ; increment byte pointer
        txa                     ; get address LSB
        eor     mnstad+1        ; twiddle against start LSB
        cmp     #$80            ; see if 128 bytes
        bne     mnec1l          ; if not, on to next
        sec                     ; if already earsed, clear error flag
        rts                     ; all done!
mnec1x: clc                     ; not erased flag
        rts                     ; all done

        page
*******************************************************************************
*       mndlym: wait # of milliseconds in A
*       mndlyu: wait # of microseconds in A
*         Microseconds isn't too accurate, especially in debug mode, but is
*         close enough for what I want.
*       CODE for ERASE routine, copied again for Program Routine
*******************************************************************************
;* <A NAME="Erase Delay Routines (RAM)">
mndlym: clrx                    ; (1) h:x to 0
        clrh                    ; (1) 2nd part
mndly1: aix     #1              ; (2) increment
$IF DEBUG
        cphx    #306            ; (3) 1ms @8 2.45MHz clocks is 306 loops
$ELSEIF
        cphx    #1000           ; (3) 1ms @8 8.00MHz clocks is 1000 loops
$ENDIF
        bne     mndly1          ; (3) if not, loop again
        deca                    ; (1) decrement millisecond counter
        bne     mndlym          ; (3) loop for specified number of milliseconds
        clrh                    ; (1) leave H zero
        rts                     ; (4) All done

mndlyu:
$IF DEBUG
        lsra                    ; for debug mode, just divide A by 4
        lsra                    ; other half of above directive
$ENDIF

mndly2: nop                     ; (1) wait a bit
        nop                     ; (1) wait some more
        nop                     ; (1) wait some more
        nop                     ; (1) wait some more
        deca                    ; (1) decrement delay counter
        bne     mndly2          ; (3) loop till done
        rts                     ; (4) all done
mnerre: ; Erase RAM code end
mnpgrb: ; Program RAM code begin
*******************************************************************************
*       This is the low-level routine to program 8 bytes of Flash.  The 8
*       bytes to program start at (mndray).  This routine assumes that the
*       8 bytes of data have already been erased and the starting address
*       (mnstad) is on an 8-byte boundry.
*       Numbers in brackets are step numbers per the 6808 manual section 11.7
*       C set means pgm went OK
*       c clear means programming failure
*******************************************************************************
;* <A NAME="Program sector (RAM)">
mnpgm8: lda     #$01            ; (1) Set the PGM bit
        sta     flcr            ;     set it

        lda     flbpr           ; (2) read the block protect register

        ldhx    mnstad          ; (3) the block start address
        sta     ,x              ;     write to first address of target block

        lda     #10             ; (4) 10us Tnvs delay
        bsr     mndlpu          ;     us delay routine

        lda     #$09            ; (5) Set the HVEN bit (PGM still set)
        sta     flcr            ;     set it

        lda     #5              ; (6) 6us Tpgs delay
        bsr     mndlpu          ;     us delay routine

        ldhx    mnstad          ; (7) the first address to write to
        sthx    mntmph          ;     save it
        ldhx    #mndray         ;     the source data
mnpg8l: mov     x+,mntmp2       ;     get a byte
        pshh                    ;     save MSB
        pshx                    ;     LSB too
        ldhx    mntmph          ;     get dest address
        mov     mntmp2,x+       ;     store the data
        sthx    mntmph          ;     save incremented dest addr

        lda     #30             ; (8) 30us Tprog delay
        bsr     mndlpu          ;     us delay routine

        pulx                    ; (9) get src address LSB
        pulh                    ;     get src address MSB
        txa                     ;     get src address LSB in A
        and     #$07            ;     three LSBs only
        cmp     #mndray&$07     ;     see if last address
        bne     mnpg8l          ;     if not, next byte

        lda     #$08            ; (10) Clear the PGM bit (HVEN still set)
        sta     flcr            ;      set it

        lda     #5              ; (11) 5us Tnvh delay
        bsr     mndlpu          ;      us delay routine

        lda     #$00            ; (12) clear the HVEN bit
        sta     flcr            ;      set it

        lda     #1              ; (13) 1us Trcv delay
        bsr     mndlpu          ;      us delay routine

mnpg8x: sec                     ; set success flag (failure not an option!)
        rts                     ; return with pass/fail set

        page
*******************************************************************************
*       mndlpm: wait # of milliseconds in A
*       mndlyu: wait # of microseconds in A
*         Microseconds isn't too accurate, especially in debug mode, but is
*         close enough for what I want.
*       CODE for ERASE routine, copied again for Program Routine
*******************************************************************************
;* <A NAME="Pgm Delay Routines (RAM)">
mndlpm: clrx                    ; (1) h:x to 0
        clrh                    ; (1) 2nd part
mndlp1: aix     #1              ; (2) increment
$IF DEBUG
        cphx    #306            ; (3) 1ms @8 2.45MHz clocks is 306 loops
$ELSEIF
        cphx    #1000           ; (3) 1ms @8 8.00MHz clocks is 1000 loops
$ENDIF
        bne     mndlp1          ; (3) if not, loop again
        deca                    ; (1) decrement millisecond counter
        bne     mndlpm          ; (3) loop for specified number of milliseconds
        clrh                    ; (1) leave H zero
        rts                     ; (4) All done

mndlpu:
$IF DEBUG
        lsra                    ; for debug mode, just divide A by 4
        lsra                    ; other half of above directive
$ENDIF

mndlp2: nop                     ; (1) wait a bit
        nop                     ; (1) wait some more
        nop                     ; (1) wait some more
        nop                     ; (1) wait some more
        deca                    ; (1) decrement delay counter
        bne     mndlp2          ; (3) loop till done
        rts                     ; (4) all done

mnpgre: ; Program RAM code end
        page
; -----------------------------------------------------------------------------
; Routine:      mnshi
; Called By:    mnhwin
; Calls:        mnwini
; Gazintas:     None
; Gazoutas:     None
; Function:     Puts up the spash screen for debug mode.
; -----------------------------------------------------------------------------

mnshi:  mov     #$80,mntmp3     ; Want to send half-command.
        clr     mntmpl          ; regular command.
        lda     #mnini0         ; initialization byte #0 (fake 8-bit)
        jsr     mnwini          ; send it
        lda     #mnini0         ; initialization byte #0 (fake 8-bit)
        jsr     mnwini          ; send it
        lda     #mnini0         ; initialization byte #0 (fake 8-bit)
        jsr     mnwini          ; send it
        lda     #mnini1         ; initialization byte #1 (real 4-bit)
        jsr     mnwini          ; send it

        clr     mntmp3          ; full commands
        lda     #mnini1         ; initialization byte #1
        jsr     mnwini          ; send it
        lda     #mnini2         ; initialization byte #2
        jsr     mnwini          ; send it
        lda     #mnini3         ; initialization byte #3
        jsr     mnwini          ; send it
        lda     #mnini4         ; initialization byte #4
        jsr     mnwini          ; send it
        lda     #mnini5         ; initialization byte #5
        jsr     mnwini          ; send it
        lda     #mnini6         ; initialization byte #6
        jsr     mnwini          ; send it

        ldhx    #mnbanr         ; first line of data
        sthx    mnstad          ; save it

        clr     mntmpl          ; command bytes again
        lda     #$80            ; line 1 column 1...
        bsr     mnwini          ; set it
        bsr     mnwlin          ; write line # 1

        clr     mntmpl          ; command bytes again
        lda     #$c0            ; line 2 column 1...
        bsr     mnwini          ; set it
        bsr     mnwlin          ; write line # 2

        rts                     ; all done

; -----------------------------------------------------------------------------
; Routine:      mnwini
; Called By:    losta routines
; Calls:        None
; Gazintas:     A: byte to write
; Gazoutas:     None
; Function:     This code will write a byte to the data register of the LCD
;               The byte to write is in the A register.  This routine breaks
;               up the 8 bits of data into two 4-bit chunks and writes them
;               out one at a time.  The byte written is a command byte, but
;               instead of checking to see if LCD controller is ready first,
;               I just send the command without asking and then delay the
;               maximum amount before returning.  This is needed for the first
;               initialization bytes before we can count on the ready bit
;               being correct.
; -----------------------------------------------------------------------------
mnwini: tax                     ; save data to send in X

        lda     ddra            ; get dir regs
        ora     #$fe            ; all bits ex 0 to ouputs
        sta     ddra            ; do that

        txa                     ; get data back
        and     #$f0            ; MSB only
        ora     mntmpl          ; Merge control bits RS,RW,Strobe
        sta     porta           ; assert MSB plus controls
        bset    3,porta         ; assert the strobe
        nsa                     ; waste some time
        nsa                     ; waste some time
        bclr    3,porta         ; unassert the strobe

        tst     mntmp3          ; see if a half-command
        bne     mnwine          ; if so, exit now

        txa                     ; get back data to write
        nsa                     ; put LSN in MSN
        and     #$f0            ; MSB only
        ora     mntmpl          ; Merge control bits RS,RW,Strobe
        sta     porta           ; assert MSB plus controls
        nop                     ; wait a bit
        bset    3,porta         ; assert the strobe
        nsa                     ; waste some time
        nsa                     ; waste some time
        bclr    3,porta         ; unassert the strobe

mnwine: lda     #2              ; 5 miliseconds
        jsr     mndlpm          ; wait it
        rts                     ; all done!

        page

; -----------------------------------------------------------------------------
; Routine:      mnwlin
; Called By:    mnshi
; Calls:        mnwini
; Gazintas:     mnstad
; Gazoutas:     none
; Function:     This code will write 20 ascii characters to the LCD data port.
;               The address for these characters are already stored in location
;               mnstad
; -----------------------------------------------------------------------------
mnwlin: mov     #$02,mntmpl     ; now want to write data bytes
        lda     #20             ; twenty bytes per line
        sta     mntmp2          ; save this
mnwlup: ldhx    mnstad          ; get message address
        lda     ,x              ; get a byte to send
        aix     #1              ; increment pointer
        sthx    mnstad          ; save result

        bsr     mnwini          ; write it
        dec     mntmp2          ; decrement character counter
        bne     mnwlup          ; do this 20 times
        rts                     ; all done



mnini0: equ     $38             ; LCD init byte 1 8-bit IF, 2-line, 5x7 font
mnini1: equ     $28             ; LCD init byte 1 4-bit IF, 2-line, 5x7 font
mnini2: equ     $14             ; LCD init byte 2 cursor shift, shift right
mnini3: equ     $0c             ; LCD init byte 3 Display on, cursor off, blink off
mnini4: equ     $06             ; LCD init byte 4 cursor increment, display doesn't
mnini5: equ     $02             ; LCD init byte 5 Cursor at home
mnini6: equ     $01             ; LCD init byte 6 Clear display

mnbanr: db      'Monitor Ver 1.01.0C '
        db      'Start MON08 on PC...'

        page
