.pagewidth 132
.header "Radial Clock Controller"
.subheader "Ver 1.07.0R Sept 20, 2008"
******************************************************
** Copyright 2007 CMI Productions.                  **
** Lots of rights reserved.                         **
** Free for personal use as long as this copyright  **
** message is maintained in the source.  Commercial **
** use prohibited without CMIs written concent.     **
******************************************************
* This is the control program for an MC68HC908GP32 that will control a clock
* consisting of two rows of LEDs, an outer row of 60 LEDs representing the
* minutes/seconds from 0-59 and an inner row of 48 LEDs representing quarter-
* hours from 1 to 12.  The hours ring also has 12 more LEDs (every 5th one)
* used as tick marks for the 12 hours.  Additionally, the clock has a 30x16
* LED matrix in the center.  The LEDs are organized as a matrix of 8 rows
* times a total of 80 columns.  68 colums are fully populated, 8 colums are
* partially populated, and four are unpopulated.  See the schematic for details.
*
* MC68HC906GP32 port assignments
* PA0 (I/O) debug           PB0 (O) Col D0 PC0 (I) SW Up    PD0 (O) Row 4
* PA1 (O) Col driver clock  PB1 (O) Col D1 PC1 (O) WWVB ena PD1 (O) Row 5
* PA2 (O) Col driver clear  PB2 (O) Col D2 PC2 (I) SW Dn    PD2 (O) Row 6
* PA3 (O) Col driver latch  PB3 (O) Col D3 PC3 (I) SW Ent   PD3 (O) Row 7
* PA4 (O) Row 0             PB4 (O) Col D4 PC4 (I) SW Menu  PD4 (O) T1CH0 Col driver ENA
* PA5 (O) Row 1             PB5 (O) Col D5 PC5 N/A   N/A    PD5 (I) WWVB data
* PA6 (O) Row 2             PB6 (O) Col D6 PC6 N/A   N/A    PD6 N/A N/A
* PA7 (O) Row 3             PB7 (O) Col D7 PC7 N/A   N/A    PD7 N/A N/A
*
* OVERVIEW
* ========
* This code will drive the radial clock.  More data here as I write the code.
*
*
*
* ==============================================================================
* ==============================================================================
*
* 1.00.0: (start through 4/28/07)
*    Initial release good enough to show.
*    Basic time setting and keeping.
* 1.01.0: (4-30-07)
*    First crack at WWVB support--unfinished (wwvb.asm)
* (May-Oct 2007) On haitus while I worked on the kitchen remodel!
* 1.02.0: (11-1-07)
*    Fixed a bug in the date/time setting routine
*    Changed ssmode #2 to seconds bargraph
* 1.03.00: (11-27-07)
*    Added a "display hold" feature to stop automatic clock display updates
*    Added a cheesy LED "light test" splash at startup
* (Nov-Aug) Another haitus while I got the Z80 version working.
* 1.04.00: (08-09-08)
*    Added "Phase B" for rings so I can blink minutes and hours LEDs
*    Added support for setting the year
* 1.05.00 (09-07-08)
*    Got the first round of WWVB support working!
* 1.06.00 (09-16-08)
*    Better validated leap year support and "Day 200" support
*    Wrote and validated DST transitions
*    Wrote and validated Leap Second support
* 1.07.00 (9-19-09)
*    Added the code to re-sync to WWVB at midnight local
*    Significantly cleaned up and organized the code in this file
*    Did some (better) error handling of WWVB bit errors
*    Change the WWVB LED to the 12 o'clock tick mark
*    Broke out UI code and put it into ui.asm
*    Added basic code to set WWV time zone, DST observation
*    Added access back to manual time setting code
*      Right now, if you change TZ or DSO, you must re-acquire WWVB data
*      Oops, more reading shows leap seconds are at midnight UTC, not local!
*
* ======================================================================
* USER-SETTABLE DEFINES FOR THE FEW COMPILE-TIME OPTIONS.
* ======================================================================
* $SET    DEBUG is for debug mode (2.4576MHz CPU clock from 4.9143MHz crystal)
* $SETNOT DEBUG is for standalone mode (8MHz CPU clock from 32MHz crystal)
$SETNOT DEBUG
*
* $SET    WWVDBG is to test various WWV decoding states (preloads certain times)
* $SETNOT WWVDBG is for normal mode
$SETNOT WWVDBG

        page
$base 10T
$Include "gpgtregs.inc"
$Include "mymon.asm"

; APPLICATION SPECIFIC EQUATES...

knone:  equ     0               ; keycode for no-key
kmenu:  equ     1               ; keycode for menu button
kup:    equ     2               ; keycode for up button
kdown:  equ     3               ; keycode for down button
ksel:   equ     4               ; keycode for select button
kwait:  equ     255             ; keycode for no-new-key

;       Flags for various bits from the wwvb symbol parser
wwvsnn: equ     0               ; Nuthin yet
wwvspm: equ     1               ; Got a Px Marker
wwvs0:  equ     2               ; Got a 0 bit
wwvs1:  equ     3               ; got a 1 bit
wwvsxx: equ     4               ; Got Gunk



$include "ram.asm"              ; the RAM table
        page
;       This is where all the vectors that get processed by MON08 get vectored
;       to.

        org     uvtbas          ; Vector for Application timebase vector
        jmp     rstrtn          ; not used
        org     uvadc           ; Vector for Application A/D conversion Complete
        jmp     rstrtn          ; not used
        org     uvkey           ; Vector for Application Keyboard
        jmp     rstrtn          ; not used
        org     uvsctx          ; Vector for Application SCI Tx
        jmp     rstrtn          ; not used
        org     uvscrx          ; Vector for Application SCI Rx
        jmp     rstrtn          ; not used
        org     uvscer          ; Vector for Application SCI Error
        jmp     rstrtn          ; not used
        org     uvsptx          ; Vector for Application SPI Tx
        jmp     rstrtn          ; not used
        org     uvsprx          ; Vector for Application SPI Rx
        jmp     rstrtn          ; not used
        org     uvt2ov          ; Vector for Application Timer 2 overflow
        jmp     rstrtn          ; not used
        org     uvt2c1          ; Vector for Application Timer 2 channel 1
        jmp     rstrtn          ; not used
        org     uvt2c0          ; Vector for Application Timer 2 channel 0
        jmp     rstrtn          ; not used
        org     uvt1ov          ; Vector for Application Timer 1 overflow
        jmp     rstrtn          ; not used
        org     uvt1c1          ; Vector for Application Timer 1 channel 1
        jmp     rstrtn          ; not used
        org     uvt1c0          ; Vector for Application Timer 1 channel 0
        jmp     timrtn          ; ******* USED!!! (100ms general purpose timer)
        org     uvpll           ; Vector for Application PLL
        jmp     rstrtn          ; not used
        org     uvirq           ; Vector for Application external IRQ
        jmp     rstrtn          ; not used
        org     uvswi           ; Vector for Application SWI instruction
        jmp     rstrtn          ; not used
        org     uvrst           ; Vector for Application power-on-reset
        jmp     rstrtn          ; go to our general-purpose startup routine

        page
; -----------------------------------------------------------------------------
; Routine:      rstrtn
; Called By:    Power-on reset
; Calls:
; Gazintas:     None
; Gazoutas:     None really
; Function:     This is the main routine, we get here after reset assuming
;               MON08 doesn't sieze control.  It is the main loop and doesn't
;               return.
; -----------------------------------------------------------------------------
rstrtn: ldhx    #aprend         ; the end of application RAM
        txs                     ; make it the stack pointer
        clrh                    ; leave H 0

;       The first function is really a range check.  I divide RAM into
;       the $40-$ff range and then $100+ range.  If the lower range exceeds
;       $ff, this clear instruction will generate an error.

        clr     ramff           ; will generate an assembler error if >#$ff

;       Go initialize all the GPIO ports to their default states and turn off
;       the COP

        clr     porta           ; Port A all lows
        mov     #$fe,ddra       ; Port A all outputs except bit 0 (for MON08)

        mov     #$00,portb      ; 1-wire: 0 drives low, 1,2 drive high.
        mov     #$ff,ddrb       ; Drive unused pin, Switches and 1-wire tristate

        mov     #$02,portc      ; 0's for any driven outputs except PTC1 (disable WWVB)
        mov     #$02,ddrc       ; All inputs except bit 0 (IRQ busy flag)
        mov     #$00,portd      ; 0's for now
        mov     #$df,ddrd       ; All outputs except WWVB input

        mov     #$ff,ptcpue     ; pull up all pins when inputs

        bset    0,config1       ; turn off COP for now

;       Initialize all the variables that need initializing.

        clr     ruftim          ; rough time counter (100ms)
        clr     phase           ; clear the phase counter
        mov     #1,rtchld       ; RTC hold flag (non-0=hold)
        mov     #1,dsphld       ; display time hold (non-0=hold)
        clr     ssecs           ; The Time: 1/60ths of a second
        clr     secs            ; The Time: seconds
        clr     mins            ; The Time: minutes
        clr     hrs             ; The Time: hours
        mov     #1,day          ; The Time: day of month
        mov     #1,month        ; The Time: month
        clr     year            ; The Time: year
        clr     curkey          ; The debounced key value
        clr     drow            ; initialize display row number
        clr     blink           ; no blinking
        mov     #$ff,pmins      ; sync value for minutes display (want it bad)
        clr     ssmode          ; sub-seconds display mode
        mov     #1,newtim       ; new time flag (for LED Matrix)
        clr     wwvbst          ; WWVB state machine state 0=idle
        clr     wwvdsf          ; clear the DST transition flag
        clr     wwvlsf          ; clear the Leap Second flag

;       Now for the higher level initialization routines

        jsr     tclr            ; clear the time display array
        jsr     dclr            ; clear the text display array
        jsr     initmr          ; initialize the timer hardware and enable timer interrupts
        jsr     ledtst          ; Before we start time, do a fancy LED test
        jsr     gtime           ; Go get the initial time from WWVB

        page
; -----------------------------------------------------------------------------
; Routine:      dclock and mloop
; Called By:    Infinite loop in main
; Calls:        None
; Gazintas:     None
; Gazoutas:
; Function:     This is the main line code while the clock is running in the
;               background.  All time keeping and display functions are in
;               interrupt routines.
;               dtime is the entry point and mloop is the main loop.
;               This loop only does two things.  If normal time functions are
;               being displayed, I change the ssmode (how sub-seconds are
;               displayed) every minute to make things a bit more interesting.
;               Secondly, I check to see if the Menu button gets pressed, and
;               if so, go to the menu routines.
; -----------------------------------------------------------------------------
dclock: clr     dsphld          ; start displaying time
        clr     rtchld          ; make sure time is incrementing
        mov     #1,newtim       ; flag a new time (for LED matrix update)

mloop:  lda     mins            ; get current minutes value
        cmp     pmins           ; compare to last update
        beq     mmmdun          ; if same, no changes since last update

        sta     pmins           ; save current as last updated
        clrh                    ; 16-bit value for div
        ldx     #5              ; value to divide by
        div                     ; divide, H has reminder, so mins mod 5
        pshh                    ; want H (remainder), so put it on the stack
        pula                    ; get it into A
        sta     ssmode          ; save it

;       Only option at this time is to set the time.  Hence, if the user
;       presses the menu key, go to the time setting routine.  Otherwise just
;       go scan everything all over again.

mmmdun: lda     curkey          ; get current key code
        cmp     #kmenu          ; see if menu key
        beq     lmenus          ; if so, go to menu code
        bra     mloop           ; if none of the above, just go back to waiting

lmenus: jsr     menus           ; long jump to the menus
        bra     dclock          ; go back to menu when done

        page
; -----------------------------------------------------------------------------
; Other source code modules
; -----------------------------------------------------------------------------
$include "ui.asm"               ; Menuing routines
$include "dtime.asm"            ; time display routines
$include "dtext.asm"            ; text display routines
$include "timirq.asm"           ; Timer Interrupt
$include "wwvb.asm"             ; WWVB acquisition routines
$include "util.asm"             ; Utilities
$include "tables.asm"           ; Tables
$include "nvm.asm"              ; nonvolatile storage


