/* Number of simulation modes */
#define N_MODES 3
/* # of years stash for mode 2 */
#define M2Years 2

typedef struct results_t            /* Results of a single simulation run */
{
   float  estate[N_MODES]         ; /* Leftover $ in each mode            */
   float  avg_ror                 ; /* Average RoR for this sim           */
} RESULTS ;
   
typedef struct sim_t                /* The parameters for the simulations */
{
   float  start                   ; /* start of year balance              */
   float  rord                    ; /* rate of return in dollars          */
   float  spend1act               ; /* actual spend for the year (Cat 1)  */
   float  spend2act               ; /* actual spend for the year (Cat 2)  */
   float  spend3act               ; /* actual spend for the year (Cat 3)  */
   float  final                   ; /* end of year balance                */
   float  cache                   ; /* Mode 2 cash cache                  */
} SIMD ;

typedef struct yearly_t             /* The parameters for the simulations */
{
   uint32 age                     ; /* current age                        */
   uint32 year                    ; /* current year                       */
   float  ror_avg                 ; /* current Rate of Return average     */
   float  ror_dev                 ; /* current Rate of Return deviation   */
   float  rorp                    ; /* The random rate of return (%)      */
   float  rort                    ; /* The totalized rate of return (%)   */
   float  cat1max                 ; /* Category 1 max (desired) spend     */
   float  cat2max                 ; /* Category 2 max (desired) spend     */
   float  cat3max                 ; /* Category 3 max (desired) spend     */
   float  cat1min                 ; /* Category 1 minimum spend           */
   float  cat2min                 ; /* Category 2 minimum spend           */
   float  cat3min                 ; /* Category 3 minimum spend           */
   float  soc_sec_adder           ; /* Social Security adder (if added)   */
} YEARLY ;

typedef struct summary_t
{
   uint32 successes ; /* Success counters   */
   float  min_left  ; /* Min estate at end  */
   float  max_left  ; /* Min estate at end  */
   float  avg_left  ; /* Avg estate at end  */
   float  mean_left ; /* Mean estate at end */
} SUMMARY ;   

typedef struct batch_summary_t
{
   char  descr[50] ; /* Batch description     */
   uint8 mode[3]   ; /* results for each mode */
} BATCH_SUMMARY_T ;

extern FILE *flog    ; /* the command file     */

extern SUMMARY         summaries[N_MODES]   ; /* simulation summaries by mode   */
extern RESULTS         *results             ; /* results array                  */
extern BATCH_SUMMARY_T batch_results[20]    ; /* batch results array            */

int  run_sims  (void) ;
int  run_batch (void) ;
void sims_done (void) ;

