#include <stdio.h>

#include "def.h"
#include "common.h"

/************************************************************************/
/* This is a handy consolication rotuinet to open a file called out in  */
/* a config file.  Supply the program name, variable and file handle,   */
/* and it takes care of the rest, including error handling.             */
/* INPUTS  : program - ini file program name                            */
/*           keyname - ini file variable name (the filename)            */
/*           file    - pointer to the file handle                       */
/*           mode    - File mode (r,w,rb, etc...)                       */
/* RETURNS : 0 for success (with file handle ready)                     */
/*           1 for any kind of failure                                  */
/*                                                                      */
/* Failure messages are printed to the console before exiting.          */
/************************************************************************/
uint32 ckopen (char* program, char* keyname, FILE** handle, char* mode)
{
   char* param ;

   /* Get the file name based on the key value */
   param = INI_GetString(program,keyname) ;
   if (param==NULL)
   {
      ShowFail();
      printf ("%s parameter missing.\n",keyname) ;
      return(1) ;
   } ;

   /* Open the file */
   if ((*handle=fopen(param,mode)) == NULL)
   {
      ShowFail();
      printf("Error opening %s file %s",keyname,param) ;
      perror(" ");
      return(1) ;
   } ;

   /* if no problems, return success! */
   return (0) ;
}


/************************************************************************/
/* This routine gets called on every failure.  Idea is that we print    */
/* out the "started" message and on the first and only failure, print   */
/* FAIL! on the status line before printing the error.  If we get to    */
/* end of the program without failure, we print OK.                     */
/************************************************************************/
void ShowFail(void)
{
   static uint8 first=TRUE ;

   if (first)
   {
      printf (" FAIL!\n") ;
      first=FALSE ;
   }
} ;

