#include <stdio.h>
#include "def.h"
#include "Simulation.h"
#include "sorts.h"

/****************************************************************************
* Routines : rorsort, res1sort,res2sort
* Gazintas : a,b - record to sort by
* IOs      : None
* Returns  : +1, -1 depending on sort
* Globals  : None
*
* These are the call-back routines for qsort.  I have routines to sort by
* rate of return as well as Mode 1 results.
****************************************************************************/

int rorsort(const RESULTS* a, const RESULTS* b)
{
   return ((a->avg_ror<b->avg_ror)?-1:+1) ;
} ;

int res0sort(const RESULTS* a, const RESULTS* b)
{
   return ((a->estate[0]<b->estate[0])?-1:+1) ;
} ;

int res1sort(const RESULTS* a, const RESULTS* b)
{
   return ((a->estate[1]<b->estate[1])?-1:+1) ;
} ;

int res2sort(const RESULTS* a, const RESULTS* b)
{
   return ((a->estate[2]<b->estate[2])?-1:+1) ;
} ;

