typedef struct params_t             /* The parameters for the simulations */
{
   uint8  first                   ; /*  0 First time call                    */
   float  start_amount            ; /*  1 initial stash of cash to use       */
   uint32 start_year              ; /*  2 Year of retirement                 */
   uint32 start_age               ; /*  3 Age at start of retirement         */
   uint32 end_age                 ; /*  4 Age to stop simulation             */
   float  mkt_return_avg          ; /*  5 Average market return to assume    */
   float  mkt_return_range        ; /*  6 max deviation (+ & -) from average */

   uint32 age_ror_phase2          ; /*  7 age at which phase 2 RoR starts    */
   float  mkt_return_avg2         ; /*  8 Average market return to assume    */
   float  mkt_return_range2       ; /*  9 max deviation (+ & -) from average */
   
   uint32 age_ror_phase3          ; /* 10 age at which phase 3  RoR starts   */
   float  mkt_return_avg3         ; /* 11 Average market return to assume    */
   float  mkt_return_range3       ; /* 12 max deviation (+ & -) from average */
   
   char   cat1_expense_name[20]   ; /* 13 Category 1 expense name            */
   float  cat1_expense_amount_min ; /* 14 Category 1 expense min spend       */
   float  cat1_expense_amount_max ; /* 15 Category 1 expense max spend       */
   float  cat1_expense_inflation  ; /* 16 Category 1 inflation rate          */

   char   cat2_expense_name[20]   ; /* 17 Category 2 expense name            */
   float  cat2_expense_amount_min ; /* 18 Category 2 expense min spend       */
   float  cat2_expense_amount_max ; /* 19 Category 2 expense max spend       */
   float  cat2_expense_inflation  ; /* 20 Category 2 inflation rate          */

   char   cat3_expense_name[20]   ; /* 21 Category 3 expense name            */
   float  cat3_expense_amount_min ; /* 22 Category 3 expense min spend       */
   float  cat3_expense_amount_max ; /* 23 Category 3 expense max spend       */
   float  cat3_expense_inflation  ; /* 24 Category 3 inflation rate          */

   uint32 soc_sec_age_start       ; /* 25 Age to start social security       */
   float  soc_sec_amt             ; /* 26 Yearly amount (at start)           */
   float  soc_sec_inflation       ; /* 27 Social Security inflation          */
   uint8  soc_sec_use             ; /* 28 Use it (for easier what-ifs)       */

   uint32 num_sims                ; /* 29 Number of simulations to run       */
   uint8  logs                    ; /* 30 Logs flag (print yearly logs)      */
   uint8  detail_summary          ; /* 31 Summary flag (randomized results   */
   uint8  histogram               ; /* 32 Histogram flag                     */
   uint8  debug                   ; /* 33 Debug flag (print debug data)      */

   char   SummaryFile[MAX_PATH]   ; /* 34 Output file base name              */
   char   HistogramFile[MAX_PATH] ; /* 35 Output file base name              */
} PARAMS ;

typedef struct batch_t
{
   float BStash[5]  ; /* The stashes for each of the five retirement years */
   float AltCPI     ; /* Alternate CPI                                     */
   uint8 UseAltCPI1 ; /* Use Alternate CPI for expense category 1          */
   uint8 UseAltCPI2 ; /* Use Alternate CPI for expense category 2          */
   uint8 UseAltCPI3 ; /* Use Alternate CPI for expense category 3          */
   uint8 BothSSIs   ; /* Sims with SSI included and excluded               */
} BATCH ;

void  init_params  (void     ) ;
uint8 read_params  (char*,int) ;
void  write_params (FILE*    ) ;
void  save_params  (char*    ) ;

extern PARAMS params    ; /* parameter structure    */
extern uint8 Perror[36] ; /* error flag array       */
extern BATCH BatchDat   ; /* Batch data             */
extern uint8 Berror[11] ; /* Batch error flag array */
extern uint8 nbatch     ; /* # of batch runs        */
extern uint8 nbatchs    ; /* # of batch SSIs        */
extern uint8 nbatchc    ; /* # of batch CPIs        */

#define PARAMS_ERR_NONE   0
#define PARAMS_ERR_BOX    100
#define PARAMS_ERR_MINMAX 101

